/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.command.DebugCommand;

class DebugCommandCodec
extends CommandCodec<Void, DebugCommand> {
    private static final int PAYLOAD_LENGTH = 1;

    DebugCommandCodec(DebugCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        this.sendDebugCommand();
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength, int sequenceId) {
        this.handleOkPacketOrErrorPacketPayload(payload);
    }

    private void sendDebugCommand() {
        ByteBuf packet = this.allocateBuffer(5);
        packet.writeMediumLE(1);
        packet.writeByte(this.sequenceId);
        packet.writeByte(13);
        this.sendPacket(packet, 1);
    }
}

