/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import io.vertx.mysqlclient.impl.codec.ColumnDefinition;
import io.vertx.mysqlclient.impl.codec.DataFormat;
import io.vertx.mysqlclient.impl.codec.DataType;
import io.vertx.mysqlclient.impl.codec.DataTypeCodec;
import io.vertx.mysqlclient.impl.codec.MySQLPreparedStatement;
import io.vertx.mysqlclient.impl.codec.Packets;
import io.vertx.mysqlclient.impl.codec.QueryCommandBaseCodec;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommandBase;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;

abstract class ExtendedQueryCommandBaseCodec<R, C extends ExtendedQueryCommandBase<R>>
extends QueryCommandBaseCodec<R, C> {
    protected final byte sendType = 1;
    protected final MySQLPreparedStatement statement;

    ExtendedQueryCommandBaseCodec(C cmd) {
        super(cmd, DataFormat.BINARY);
        this.statement = (MySQLPreparedStatement)cmd.preparedStatement();
    }

    @Override
    protected void handleInitPacket(ByteBuf payload) {
        short firstByte = payload.getUnsignedByte(payload.readerIndex());
        if (firstByte == 0) {
            Packets.OkPacket okPacket = this.decodeOkPacketPayload(payload, StandardCharsets.UTF_8);
            this.handleSingleResultsetDecodingCompleted(okPacket.serverStatusFlags(), (int)okPacket.affectedRows(), (int)okPacket.lastInsertId());
        } else if (firstByte == 255) {
            this.handleErrorPacketPayload(payload);
        } else {
            this.handleResultsetColumnCountPacketBody(payload);
        }
    }

    protected void sendStatementExecuteCommand(long statementId, ColumnDefinition[] paramsColumnDefinitions, byte sendType, Tuple params, byte cursorType) {
        ByteBuf packet = this.allocateBuffer();
        int packetStartIdx = packet.writerIndex();
        packet.writeMediumLE(0);
        packet.writeByte(this.sequenceId);
        packet.writeByte(23);
        packet.writeIntLE((int)statementId);
        packet.writeByte((int)cursorType);
        packet.writeIntLE(1);
        int numOfParams = paramsColumnDefinitions.length;
        int bitmapLength = (numOfParams + 7) / 8;
        byte[] nullBitmap = new byte[bitmapLength];
        int pos = packet.writerIndex();
        if (numOfParams > 0) {
            Object value;
            int i;
            packet.writeBytes(nullBitmap);
            packet.writeByte((int)sendType);
            if (sendType == 1) {
                for (i = 0; i < numOfParams; ++i) {
                    value = params.getValue(i);
                    packet.writeByte(this.parseDataTypeByEncodingValue((Object)value).id);
                    packet.writeByte(0);
                }
            }
            for (i = 0; i < numOfParams; ++i) {
                value = params.getValue(i);
                if (value != null) {
                    DataTypeCodec.encodeBinary(this.parseDataTypeByEncodingValue(value), value, packet);
                    continue;
                }
                int n = i / 8;
                nullBitmap[n] = (byte)(nullBitmap[n] | 1 << (i & 7));
            }
            packet.setBytes(pos, nullBitmap);
        }
        int payloadLength = packet.writerIndex() - packetStartIdx - 4;
        packet.setMediumLE(packetStartIdx, payloadLength);
        this.sendPacket(packet, payloadLength);
    }

    private DataType parseDataTypeByEncodingValue(Object value) {
        if (value == null) {
            return DataType.NULL;
        }
        if (value instanceof Byte) {
            return DataType.INT1;
        }
        if (value instanceof Boolean) {
            return DataType.INT1;
        }
        if (value instanceof Short) {
            return DataType.INT2;
        }
        if (value instanceof Integer) {
            return DataType.INT4;
        }
        if (value instanceof Long) {
            return DataType.INT8;
        }
        if (value instanceof Double) {
            return DataType.DOUBLE;
        }
        if (value instanceof Float) {
            return DataType.FLOAT;
        }
        if (value instanceof LocalDate) {
            return DataType.DATE;
        }
        if (value instanceof Duration) {
            return DataType.TIME;
        }
        if (value instanceof Buffer) {
            return DataType.BLOB;
        }
        if (value instanceof LocalDateTime) {
            return DataType.DATETIME;
        }
        return DataType.STRING;
    }
}

