/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.InitialHandshakePacket;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.util.BufferUtils;
import io.vertx.mysqlclient.impl.util.Native41Authenticator;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.InitCommand;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

class InitCommandCodec
extends CommandCodec<Connection, InitCommand> {
    private static final int SCRAMBLE_LENGTH = 20;
    private static final int AUTH_PLUGIN_DATA_PART1_LENGTH = 8;
    private static final int ST_CONNECTING = 0;
    private static final int ST_AUTHENTICATING = 1;
    private static final int ST_CONNECTED = 2;
    private int status = 0;

    InitCommandCodec(InitCommand cmd) {
        super(cmd);
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength, int sequenceId) {
        switch (this.status) {
            case 0: {
                this.decodeInit0(this.encoder, (InitCommand)this.cmd, payload);
                this.status = 1;
                break;
            }
            case 1: {
                this.decodeInit1((InitCommand)this.cmd, payload);
            }
        }
    }

    private void decodeInit0(MySQLEncoder encoder, InitCommand cmd, ByteBuf payload) {
        short lenOfAuthPluginData;
        boolean isClientPluginAuthSupported;
        int releaseNumber;
        short protocolVersion = payload.readUnsignedByte();
        String serverVersion = BufferUtils.readNullTerminatedString(payload, StandardCharsets.US_ASCII);
        String[] versionNumbers = serverVersion.split("\\.");
        int majorVersion = Integer.parseInt(versionNumbers[0]);
        int minorVersion = Integer.parseInt(versionNumbers[1]);
        String releaseVersion = versionNumbers[2];
        int indexOfFirstSeparator = releaseVersion.indexOf("-");
        if (indexOfFirstSeparator != -1) {
            String releaseNumberString = releaseVersion.substring(0, indexOfFirstSeparator);
            releaseNumber = Integer.parseInt(releaseNumberString);
        } else {
            releaseNumber = Integer.parseInt(versionNumbers[2]);
        }
        if (majorVersion != 5 || minorVersion >= 7 && (minorVersion != 7 || releaseNumber >= 5)) {
            encoder.clientCapabilitiesFlag |= 0x1000000;
        }
        long connectionId = payload.readUnsignedIntLE();
        byte[] scramble = new byte[20];
        payload.readBytes(scramble, 0, 8);
        payload.readByte();
        int serverCapabilitiesFlags = payload.readUnsignedShortLE();
        short characterSet = payload.readUnsignedByte();
        int statusFlags = payload.readUnsignedShortLE();
        int capabilityFlagsUpper = payload.readUnsignedShortLE();
        boolean bl = isClientPluginAuthSupported = ((serverCapabilitiesFlags |= capabilityFlagsUpper << 16) & 0x80000) != 0;
        if (isClientPluginAuthSupported) {
            lenOfAuthPluginData = payload.readUnsignedByte();
        } else {
            payload.readerIndex(payload.readerIndex() + 1);
            lenOfAuthPluginData = 0;
        }
        payload.readerIndex(payload.readerIndex() + 10);
        payload.readBytes(scramble, 8, Math.max(12, lenOfAuthPluginData - 9));
        payload.readByte();
        String authPluginName = null;
        if (isClientPluginAuthSupported) {
            authPluginName = BufferUtils.readNullTerminatedString(payload, StandardCharsets.UTF_8);
        }
        InitialHandshakePacket initialHandshakePacket = new InitialHandshakePacket(serverVersion, connectionId, serverCapabilitiesFlags, characterSet, statusFlags, scramble, authPluginName);
        boolean ssl = false;
        if (!ssl) {
            MySQLCollation collation;
            if (cmd.database() != null && !cmd.database().isEmpty()) {
                encoder.clientCapabilitiesFlag |= 8;
            }
            String authMethodName = initialHandshakePacket.getAuthMethodName();
            byte[] serverScramble = initialHandshakePacket.getScramble();
            Map properties = cmd.properties();
            try {
                collation = MySQLCollation.valueOfName((String)properties.get("collation"));
            }
            catch (IllegalArgumentException e) {
                this.completionHandler.handle((Object)CommandResponse.failure((Throwable)e));
                return;
            }
            int collationId = collation.collationId();
            encoder.charset = Charset.forName(collation.mappedJavaCharsetName());
            Map clientConnectionAttributes = properties;
            if (clientConnectionAttributes != null && !clientConnectionAttributes.isEmpty()) {
                encoder.clientCapabilitiesFlag |= 0x100000;
            }
            encoder.clientCapabilitiesFlag &= initialHandshakePacket.getServerCapabilitiesFlags();
            this.sendHandshakeResponseMessage(cmd.username(), cmd.password(), cmd.database(), collationId, serverScramble, authMethodName, clientConnectionAttributes);
        }
    }

    private void decodeInit1(InitCommand cmd, ByteBuf payload) {
        short header = payload.getUnsignedByte(payload.readerIndex());
        switch (header) {
            case 0: {
                this.status = 2;
                this.completionHandler.handle((Object)CommandResponse.success((Object)cmd.connection()));
                break;
            }
            case 255: {
                this.handleErrorPacketPayload(payload);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void sendHandshakeResponseMessage(String username, String password, String database, int collationId, byte[] serverScramble, String authMethodName, Map<String, String> clientConnectionAttributes) {
        ByteBuf packet = this.allocateBuffer();
        int packetStartIdx = packet.writerIndex();
        packet.writeMediumLE(0);
        packet.writeByte(this.sequenceId);
        int clientCapabilitiesFlags = this.encoder.clientCapabilitiesFlag;
        packet.writeIntLE(clientCapabilitiesFlags);
        packet.writeIntLE(0xFFFFFF);
        packet.writeByte(collationId);
        byte[] filler = new byte[23];
        packet.writeBytes(filler);
        BufferUtils.writeNullTerminatedString(packet, username, StandardCharsets.UTF_8);
        if (password == null || password.isEmpty()) {
            packet.writeByte(0);
        } else {
            byte[] scrambledPassword = Native41Authenticator.encode(password, StandardCharsets.UTF_8, serverScramble);
            if ((clientCapabilitiesFlags & 0x200000) != 0) {
                BufferUtils.writeLengthEncodedInteger(packet, scrambledPassword.length);
                packet.writeBytes(scrambledPassword);
            } else if ((clientCapabilitiesFlags & 0x8000) != 0) {
                packet.writeByte(scrambledPassword.length);
                packet.writeBytes(scrambledPassword);
            } else {
                packet.writeByte(0);
            }
        }
        if ((clientCapabilitiesFlags & 8) != 0) {
            BufferUtils.writeNullTerminatedString(packet, database, StandardCharsets.UTF_8);
        }
        if ((clientCapabilitiesFlags & 0x80000) != 0) {
            BufferUtils.writeNullTerminatedString(packet, authMethodName, StandardCharsets.UTF_8);
        }
        if ((clientCapabilitiesFlags & 0x100000) != 0) {
            ByteBuf kv = this.encoder.chctx.alloc().ioBuffer();
            for (Map.Entry<String, String> attribute : clientConnectionAttributes.entrySet()) {
                if (attribute.getKey().equals("collation")) continue;
                BufferUtils.writeLengthEncodedString(kv, attribute.getKey(), StandardCharsets.UTF_8);
                BufferUtils.writeLengthEncodedString(kv, attribute.getValue(), StandardCharsets.UTF_8);
            }
            BufferUtils.writeLengthEncodedInteger(packet, kv.readableBytes());
            packet.writeBytes(kv);
        }
        int payloadLength = packet.writerIndex() - packetStartIdx - 4;
        packet.setMediumLE(packetStartIdx, payloadLength);
        this.sendPacket(packet, payloadLength);
    }
}

