/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.MySQLClient;
import io.vertx.mysqlclient.impl.codec.ColumnDefinition;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.DataFormat;
import io.vertx.mysqlclient.impl.codec.MySQLRowDesc;
import io.vertx.mysqlclient.impl.codec.Packets;
import io.vertx.mysqlclient.impl.codec.RowResultDecoder;
import io.vertx.mysqlclient.impl.util.BufferUtils;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.impl.RowDesc;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.QueryCommandBase;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.stream.Collector;

abstract class QueryCommandBaseCodec<T, C extends QueryCommandBase<T>>
extends CommandCodec<Boolean, C> {
    private final DataFormat format;
    protected CommandHandlerState commandHandlerState = CommandHandlerState.INIT;
    protected ColumnDefinition[] columnDefinitions;
    protected RowResultDecoder<?, T> decoder;
    private int currentColumn;

    QueryCommandBaseCodec(C cmd, DataFormat format) {
        super(cmd);
        this.format = format;
    }

    private static <A, T> T emptyResult(Collector<Row, A, T> collector) {
        return collector.finisher().apply(collector.supplier().get());
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength, int sequenceId) {
        switch (this.commandHandlerState) {
            case INIT: {
                this.handleInitPacket(payload);
                break;
            }
            case HANDLING_COLUMN_DEFINITION: {
                this.handleResultsetColumnDefinitions(payload);
                break;
            }
            case COLUMN_DEFINITIONS_DECODING_COMPLETED: {
                this.skipEofPacketIfNeeded(payload);
                this.handleResultsetColumnDefinitionsDecodingCompleted();
                break;
            }
            case HANDLING_ROW_DATA_OR_END_PACKET: {
                this.handleRows(payload, payloadLength, this::handleSingleRow);
            }
        }
    }

    protected abstract void handleInitPacket(ByteBuf var1);

    protected void handleResultsetColumnCountPacketBody(ByteBuf payload) {
        int columnCount = this.decodeColumnCountPacketPayload(payload);
        this.commandHandlerState = CommandHandlerState.HANDLING_COLUMN_DEFINITION;
        this.columnDefinitions = new ColumnDefinition[columnCount];
    }

    protected void handleResultsetColumnDefinitions(ByteBuf payload) {
        ColumnDefinition def = this.decodeColumnDefinitionPacketPayload(payload);
        this.columnDefinitions[this.currentColumn++] = def;
        if (this.currentColumn == this.columnDefinitions.length) {
            if (this.isDeprecatingEofFlagEnabled()) {
                this.handleResultsetColumnDefinitionsDecodingCompleted();
            } else {
                this.commandHandlerState = CommandHandlerState.COLUMN_DEFINITIONS_DECODING_COMPLETED;
            }
        }
    }

    protected void handleResultsetColumnDefinitionsDecodingCompleted() {
        this.commandHandlerState = CommandHandlerState.HANDLING_ROW_DATA_OR_END_PACKET;
        this.decoder = new RowResultDecoder(((QueryCommandBase)this.cmd).collector(), false, new MySQLRowDesc(this.columnDefinitions, this.format));
    }

    protected void handleRows(ByteBuf payload, int payloadLength, Consumer<ByteBuf> singleRowHandler) {
        short first = payload.getUnsignedByte(payload.readerIndex());
        if (first == 255) {
            this.handleErrorPacketPayload(payload);
        } else if (first == 254 && payloadLength < 0xFFFFFF) {
            int serverStatusFlags;
            int affectedRows = -1;
            int lastInsertId = -1;
            if (this.isDeprecatingEofFlagEnabled()) {
                Packets.OkPacket okPacket = this.decodeOkPacketPayload(payload, StandardCharsets.UTF_8);
                serverStatusFlags = okPacket.serverStatusFlags();
                affectedRows = (int)okPacket.affectedRows();
                lastInsertId = (int)okPacket.lastInsertId();
            } else {
                serverStatusFlags = this.decodeEofPacketPayload(payload).serverStatusFlags();
            }
            this.handleSingleResultsetDecodingCompleted(serverStatusFlags, affectedRows, lastInsertId);
        } else {
            singleRowHandler.accept(payload);
        }
    }

    protected void handleSingleRow(ByteBuf payload) {
        this.decoder.decodeRow(this.columnDefinitions.length, payload);
    }

    protected void handleSingleResultsetDecodingCompleted(int serverStatusFlags, int affectedRows, int lastInsertId) {
        this.handleSingleResultsetEndPacket(serverStatusFlags, affectedRows, lastInsertId);
        this.resetIntermediaryResult();
        if (this.isDecodingCompleted(serverStatusFlags)) {
            this.handleAllResultsetDecodingCompleted();
        }
    }

    protected boolean isDecodingCompleted(int serverStatusFlags) {
        return (serverStatusFlags & 8) == 0;
    }

    private void handleSingleResultsetEndPacket(int serverStatusFlags, int affectedRows, int lastInsertId) {
        int size;
        MySQLRowDesc rowDesc;
        T result;
        this.result = (serverStatusFlags & 0x80) == 0;
        if (this.decoder != null) {
            result = this.decoder.complete();
            rowDesc = this.decoder.rowDesc;
            size = this.decoder.size();
            this.decoder.reset();
        } else {
            result = QueryCommandBaseCodec.emptyResult(((QueryCommandBase)this.cmd).collector());
            size = 0;
            rowDesc = null;
        }
        ((QueryCommandBase)this.cmd).resultHandler().handleResult(affectedRows, size, (RowDesc)rowDesc, result);
        ((QueryCommandBase)this.cmd).resultHandler().addProperty(MySQLClient.LAST_INSERTED_ID, (Object)lastInsertId);
    }

    private void handleAllResultsetDecodingCompleted() {
        CommandResponse response = this.failure != null ? CommandResponse.failure((Throwable)this.failure) : CommandResponse.success((Object)this.result);
        this.completionHandler.handle((Object)response);
    }

    private int decodeColumnCountPacketPayload(ByteBuf payload) {
        long columnCount = BufferUtils.readLengthEncodedInteger(payload);
        return (int)columnCount;
    }

    private void resetIntermediaryResult() {
        this.commandHandlerState = CommandHandlerState.INIT;
        this.columnDefinitions = null;
        this.currentColumn = 0;
    }

    protected static enum CommandHandlerState {
        INIT,
        HANDLING_COLUMN_DEFINITION,
        COLUMN_DEFINITIONS_DECODING_COMPLETED,
        HANDLING_ROW_DATA_OR_END_PACKET;

    }
}

