/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.command.ResetConnectionCommand;

class ResetConnectionCommandCodec
extends CommandCodec<Void, ResetConnectionCommand> {
    private static final int PAYLOAD_LENGTH = 1;

    ResetConnectionCommandCodec(ResetConnectionCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        this.sendResetConnectionCommand();
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength, int sequenceId) {
        this.handleOkPacketOrErrorPacketPayload(payload);
    }

    private void sendResetConnectionCommand() {
        ByteBuf packet = this.allocateBuffer(5);
        packet.writeMediumLE(1);
        packet.writeByte(this.sequenceId);
        packet.writeByte(31);
        this.sendNonSplitPacket(packet);
    }
}

