/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.codec.DataFormat;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.codec.Packets;
import io.vertx.mysqlclient.impl.codec.QueryCommandBaseCodec;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import java.io.File;
import java.nio.charset.StandardCharsets;

class SimpleQueryCommandCodec<T>
extends QueryCommandBaseCodec<T, SimpleQueryCommand<T>> {
    SimpleQueryCommandCodec(SimpleQueryCommand<T> cmd) {
        super(cmd, DataFormat.TEXT);
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        this.sendQueryCommand();
    }

    @Override
    protected void handleInitPacket(ByteBuf payload) {
        short firstByte = payload.getUnsignedByte(payload.readerIndex());
        if (firstByte == 0) {
            Packets.OkPacket okPacket = this.decodeOkPacketPayload(payload, StandardCharsets.UTF_8);
            this.handleSingleResultsetDecodingCompleted(okPacket.serverStatusFlags(), (int)okPacket.affectedRows(), (int)okPacket.lastInsertId());
        } else if (firstByte == 255) {
            this.handleErrorPacketPayload(payload);
        } else if (firstByte == 251) {
            payload.skipBytes(1);
            String filename = this.readRestOfPacketString(payload, StandardCharsets.UTF_8);
            this.sendFileWrappedInPacket(filename);
            this.sendEmptyPacket();
        } else {
            this.handleResultsetColumnCountPacketBody(payload);
        }
    }

    private void sendQueryCommand() {
        ByteBuf packet = this.allocateBuffer();
        int packetStartIdx = packet.writerIndex();
        packet.writeMediumLE(0);
        packet.writeByte(this.sequenceId);
        packet.writeByte(3);
        packet.writeCharSequence((CharSequence)((SimpleQueryCommand)this.cmd).sql(), StandardCharsets.UTF_8);
        int payloadLength = packet.writerIndex() - packetStartIdx - 4;
        packet.setMediumLE(packetStartIdx, payloadLength);
        this.sendPacket(packet, payloadLength);
    }

    private void sendFileWrappedInPacket(String filePath) {
        File file = new File(filePath);
        long length = file.length();
        ByteBuf packetHeader = this.allocateBuffer(4);
        packetHeader.writeMediumLE((int)length);
        packetHeader.writeByte(this.sequenceId++);
        this.encoder.chctx.write((Object)packetHeader);
        this.encoder.socketConnection.socket().sendFile(filePath, 0L);
    }

    private void sendEmptyPacket() {
        ByteBuf packet = this.allocateBuffer(4);
        packet.writeMediumLE(0);
        packet.writeByte(this.sequenceId);
        this.sendNonSplitPacket(packet);
    }
}

