/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.NetSocketInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.SslMode;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.mysqlclient.impl.MySQLSocketConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.util.Collections;
import java.util.Map;

public class MySQLConnectionFactory {
    private final NetClient netClient;
    private final Context context;
    private final boolean registerCloseHook;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String database;
    private final Map<String, String> connectionAttributes;
    private final String collation;
    private final SslMode sslMode;
    private final Buffer serverRsaPublicKey;
    private final boolean cachePreparedStatements;
    private final int preparedStatementCacheSize;
    private final int preparedStatementCacheSqlLimit;
    private final Closeable hook;

    public MySQLConnectionFactory(Context context, boolean registerCloseHook, MySQLConnectOptions options) {
        String collation;
        NetClientOptions netClientOptions = new NetClientOptions((NetClientOptions)options);
        this.context = context;
        this.registerCloseHook = registerCloseHook;
        this.hook = this::close;
        if (registerCloseHook) {
            context.addCloseHook(this.hook);
        }
        this.host = options.getHost();
        this.port = options.getPort();
        this.username = options.getUser();
        this.password = options.getPassword();
        this.database = options.getDatabase();
        this.connectionAttributes = Collections.unmodifiableMap(options.getProperties());
        if (options.getCollation() != null) {
            collation = options.getCollation();
        } else {
            String charset = options.getCharset();
            collation = MySQLCollation.getDefaultCollationFromCharsetName(charset);
        }
        this.collation = collation;
        this.sslMode = options.getSslMode();
        Buffer serverRsaPublicKey = null;
        if (options.getServerRsaPublicKeyValue() != null) {
            serverRsaPublicKey = options.getServerRsaPublicKeyValue();
        } else if (options.getServerRsaPublicKeyPath() != null) {
            serverRsaPublicKey = context.owner().fileSystem().readFileBlocking(options.getServerRsaPublicKeyPath());
        }
        this.serverRsaPublicKey = serverRsaPublicKey;
        switch (this.sslMode) {
            case VERIFY_IDENTITY: {
                String hostnameVerificationAlgorithm = netClientOptions.getHostnameVerificationAlgorithm();
                if (hostnameVerificationAlgorithm == null || hostnameVerificationAlgorithm.isEmpty()) {
                    throw new IllegalArgumentException("Host verification algorithm must be specified under VERIFY_IDENTITY ssl-mode.");
                }
            }
            case VERIFY_CA: {
                TrustOptions trustOptions = netClientOptions.getTrustOptions();
                if (trustOptions != null) break;
                throw new IllegalArgumentException("Trust options must be specified under " + this.sslMode.name() + " ssl-mode.");
            }
        }
        this.cachePreparedStatements = options.getCachePreparedStatements();
        this.preparedStatementCacheSize = options.getPreparedStatementCacheMaxSize();
        this.preparedStatementCacheSqlLimit = options.getPreparedStatementCacheSqlLimit();
        this.netClient = context.owner().createNetClient(netClientOptions);
    }

    private void close(Handler<AsyncResult<Void>> completionHandler) {
        this.netClient.close();
        completionHandler.handle((Object)Future.succeededFuture());
    }

    void close() {
        if (this.registerCloseHook) {
            this.context.removeCloseHook(this.hook);
        }
        this.netClient.close();
    }

    public void connect(Handler<AsyncResult<Connection>> handler) {
        Promise promise = Promise.promise();
        promise.future().setHandler(ar1 -> {
            if (ar1.succeeded()) {
                NetSocketInternal socket = (NetSocketInternal)ar1.result();
                MySQLSocketConnection conn = new MySQLSocketConnection(socket, this.cachePreparedStatements, this.preparedStatementCacheSize, this.preparedStatementCacheSqlLimit, this.context);
                conn.init();
                conn.sendStartupMessage(this.username, this.password, this.database, this.collation, this.serverRsaPublicKey, this.connectionAttributes, this.sslMode, (Handler<? super CommandResponse<Connection>>)handler);
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar1.cause()));
            }
        });
        this.netClient.connect(this.port, this.host, (Handler)promise);
    }
}

