/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.mysqlclient.MySQLAuthOptions;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.MySQLSetOption;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.mysqlclient.impl.MySQLConnectionFactory;
import io.vertx.mysqlclient.impl.command.ChangeUserCommand;
import io.vertx.mysqlclient.impl.command.DebugCommand;
import io.vertx.mysqlclient.impl.command.InitDbCommand;
import io.vertx.mysqlclient.impl.command.PingCommand;
import io.vertx.mysqlclient.impl.command.ResetConnectionCommand;
import io.vertx.mysqlclient.impl.command.SetOptionCommand;
import io.vertx.mysqlclient.impl.command.StatisticsCommand;
import io.vertx.sqlclient.Transaction;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlConnectionImpl;

public class MySQLConnectionImpl
extends SqlConnectionImpl<MySQLConnectionImpl>
implements MySQLConnection {
    private final MySQLConnectionFactory factory;

    public static void connect(Vertx vertx, MySQLConnectOptions options, Handler<AsyncResult<MySQLConnection>> handler) {
        Context ctx = Vertx.currentContext();
        if (ctx != null) {
            MySQLConnectionFactory client;
            try {
                client = new MySQLConnectionFactory(ctx, false, options);
            }
            catch (Exception e) {
                handler.handle((Object)Future.failedFuture((Throwable)e));
                return;
            }
            client.connect((Handler<AsyncResult<Connection>>)((Handler)ar -> {
                if (ar.succeeded()) {
                    Connection conn = (Connection)ar.result();
                    MySQLConnectionImpl p = new MySQLConnectionImpl(client, ctx, conn);
                    conn.init((Connection.Holder)p);
                    handler.handle((Object)Future.succeededFuture((Object)p));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }));
        } else {
            vertx.runOnContext(v -> MySQLConnectionImpl.connect(vertx, options, handler));
        }
    }

    public MySQLConnectionImpl(MySQLConnectionFactory factory, Context context, Connection conn) {
        super(context, conn);
        this.factory = factory;
    }

    public void handleNotification(int processId, String channel, String payload) {
        throw new UnsupportedOperationException();
    }

    public Transaction begin() {
        throw new UnsupportedOperationException("Transaction is not supported for now");
    }

    public Transaction begin(boolean closeOnEnd) {
        throw new UnsupportedOperationException("Transaction is not supported for now");
    }

    @Override
    public MySQLConnection ping(Handler<AsyncResult<Void>> handler) {
        PingCommand cmd = new PingCommand();
        cmd.handler = handler;
        this.schedule(cmd);
        return this;
    }

    @Override
    public MySQLConnection specifySchema(String schemaName, Handler<AsyncResult<Void>> handler) {
        InitDbCommand cmd = new InitDbCommand(schemaName);
        cmd.handler = handler;
        this.schedule(cmd);
        return this;
    }

    @Override
    public MySQLConnection getInternalStatistics(Handler<AsyncResult<String>> handler) {
        StatisticsCommand cmd = new StatisticsCommand();
        cmd.handler = handler;
        this.schedule(cmd);
        return this;
    }

    @Override
    public MySQLConnection setOption(MySQLSetOption option, Handler<AsyncResult<Void>> handler) {
        SetOptionCommand cmd = new SetOptionCommand(option);
        cmd.handler = handler;
        this.schedule(cmd);
        return this;
    }

    @Override
    public MySQLConnection resetConnection(Handler<AsyncResult<Void>> handler) {
        ResetConnectionCommand cmd = new ResetConnectionCommand();
        cmd.handler = handler;
        this.schedule(cmd);
        return this;
    }

    @Override
    public MySQLConnection debug(Handler<AsyncResult<Void>> handler) {
        DebugCommand cmd = new DebugCommand();
        cmd.handler = handler;
        this.schedule(cmd);
        return this;
    }

    @Override
    public MySQLConnection changeUser(MySQLAuthOptions options, Handler<AsyncResult<Void>> handler) {
        String collation;
        if (options.getCollation() != null) {
            collation = options.getCollation();
        } else {
            String charset = options.getCharset();
            collation = MySQLCollation.getDefaultCollationFromCharsetName(charset);
        }
        Buffer serverRsaPublicKey = null;
        if (options.getServerRsaPublicKeyValue() != null) {
            serverRsaPublicKey = options.getServerRsaPublicKeyValue();
        } else if (options.getServerRsaPublicKeyPath() != null) {
            serverRsaPublicKey = this.context.owner().fileSystem().readFileBlocking(options.getServerRsaPublicKeyPath());
        }
        ChangeUserCommand cmd = new ChangeUserCommand(options.getUser(), options.getPassword(), options.getDatabase(), collation, serverRsaPublicKey, options.getProperties());
        cmd.handler = handler;
        this.schedule(cmd);
        return this;
    }
}

