/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.json.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MySQLConnectionUriParser {
    private static final String SCHEME_DESIGNATOR_REGEX = "(mysql|mariadb)://";
    private static final String USER_INFO_REGEX = "((?<userinfo>[a-zA-Z0-9\\-._~%!]+(:[a-zA-Z0-9\\-._~%!]*)?)@)?";
    private static final String NET_LOCATION_REGEX = "(?<host>[0-9.]+|\\[[a-zA-Z0-9:]+]|[a-zA-Z0-9\\-._~%]+)";
    private static final String PORT_REGEX = "(:(?<port>\\d+))?";
    private static final String SCHEMA_REGEX = "(/(?<schema>[a-zA-Z0-9\\-._~%!]+))?";
    private static final String ATTRIBUTES_REGEX = "(\\?(?<attributes>.*))?";
    private static final String FULL_URI_REGEX = "^(mysql|mariadb)://((?<userinfo>[a-zA-Z0-9\\-._~%!]+(:[a-zA-Z0-9\\-._~%!]*)?)@)?(?<host>[0-9.]+|\\[[a-zA-Z0-9:]+]|[a-zA-Z0-9\\-._~%]+)(:(?<port>\\d+))?(/(?<schema>[a-zA-Z0-9\\-._~%!]+))?(\\?(?<attributes>.*))?$";

    public static JsonObject parse(String connectionUri) {
        try {
            JsonObject configuration = new JsonObject();
            MySQLConnectionUriParser.doParse(connectionUri, configuration);
            return configuration;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse invalid connection URI: " + connectionUri, e);
        }
    }

    private static void doParse(String connectionUri, JsonObject configuration) {
        Pattern pattern = Pattern.compile(FULL_URI_REGEX);
        Matcher matcher = pattern.matcher(connectionUri);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Wrong syntax of connection URI");
        }
        MySQLConnectionUriParser.parseUserAndPassword(matcher.group("userinfo"), configuration);
        MySQLConnectionUriParser.parseHost(matcher.group("host"), configuration);
        MySQLConnectionUriParser.parsePort(matcher.group("port"), configuration);
        MySQLConnectionUriParser.parseSchemaName(matcher.group("schema"), configuration);
        MySQLConnectionUriParser.parseAttributes(matcher.group("attributes"), configuration);
    }

    private static void parseUserAndPassword(String userInfo, JsonObject configuration) {
        if (userInfo == null || userInfo.isEmpty()) {
            return;
        }
        if (MySQLConnectionUriParser.occurExactlyOnce(userInfo, ":")) {
            int index = userInfo.indexOf(":");
            String user = userInfo.substring(0, index);
            if (user.isEmpty()) {
                throw new IllegalArgumentException("Can not only specify the password without a concrete user");
            }
            String password = userInfo.substring(index + 1);
            configuration.put("user", MySQLConnectionUriParser.decodeUrl(user));
            configuration.put("password", MySQLConnectionUriParser.decodeUrl(password));
        } else if (!userInfo.contains(":")) {
            configuration.put("user", MySQLConnectionUriParser.decodeUrl(userInfo));
        } else {
            throw new IllegalArgumentException("Can not use multiple delimiters to delimit user and password");
        }
    }

    private static void parseHost(String hostInfo, JsonObject configuration) {
        if (hostInfo == null || hostInfo.isEmpty()) {
            return;
        }
        MySQLConnectionUriParser.parseHostValue(MySQLConnectionUriParser.decodeUrl(hostInfo), configuration);
    }

    private static void parsePort(String portInfo, JsonObject configuration) {
        int port;
        if (portInfo == null || portInfo.isEmpty()) {
            return;
        }
        try {
            port = Integer.parseInt(MySQLConnectionUriParser.decodeUrl(portInfo));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The port must be a valid integer");
        }
        if (port > 65535 || port <= 0) {
            throw new IllegalArgumentException("The port can only range in 1-65535");
        }
        configuration.put("port", Integer.valueOf(port));
    }

    private static void parseSchemaName(String schemaInfo, JsonObject configuration) {
        if (schemaInfo == null || schemaInfo.isEmpty()) {
            return;
        }
        configuration.put("database", MySQLConnectionUriParser.decodeUrl(schemaInfo));
    }

    private static void parseAttributes(String attributesInfo, JsonObject configuration) {
        if (attributesInfo == null || attributesInfo.isEmpty()) {
            return;
        }
        HashMap properties = new HashMap();
        block16: for (String parameterPair : attributesInfo.split("&")) {
            if (parameterPair.isEmpty()) continue;
            int indexOfDelimiter = parameterPair.indexOf("=");
            if (indexOfDelimiter < 0) {
                throw new IllegalArgumentException(String.format("Missing delimiter '=' of parameters \"%s\" in the part \"%s\"", attributesInfo, parameterPair));
            }
            String key = parameterPair.substring(0, indexOfDelimiter).toLowerCase();
            String value = MySQLConnectionUriParser.decodeUrl(parameterPair.substring(indexOfDelimiter + 1).trim());
            switch (key) {
                case "user": {
                    configuration.put("user", value);
                    continue block16;
                }
                case "password": {
                    configuration.put("password", value);
                    continue block16;
                }
                case "host": {
                    MySQLConnectionUriParser.parseHostValue(value, configuration);
                    continue block16;
                }
                case "port": {
                    MySQLConnectionUriParser.parsePort(value, configuration);
                    continue block16;
                }
                case "socket": {
                    configuration.put("socket", value);
                    continue block16;
                }
                case "schema": {
                    configuration.put("database", value);
                    continue block16;
                }
                default: {
                    configuration.put(key, value);
                }
            }
        }
        if (!properties.isEmpty()) {
            configuration.put("properties", properties);
        }
    }

    private static void parseHostValue(String hostValue, JsonObject configuration) {
        if (MySQLConnectionUriParser.isRegardedAsIpv6Address(hostValue)) {
            configuration.put("host", hostValue.substring(1, hostValue.length() - 1));
        } else {
            configuration.put("host", hostValue);
        }
    }

    private static boolean isRegardedAsIpv6Address(String hostAddress) {
        return hostAddress.startsWith("[") && hostAddress.endsWith("]");
    }

    private static String decodeUrl(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("The connection uri contains unknown characters that can not be resolved.");
        }
    }

    private static boolean occurExactlyOnce(String uri, String character) {
        return uri.contains(character) && uri.indexOf(character) == uri.lastIndexOf(character);
    }
}

