/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.vertx.mysqlclient.impl.codec.ExtendedQueryCommandBaseCodec;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.ExtendedBatchQueryCommand;
import java.util.List;

class ExtendedBatchQueryCommandCodec<R>
extends ExtendedQueryCommandBaseCodec<R, ExtendedBatchQueryCommand<R>> {
    private List<Tuple> params;
    private int batchIdx = 0;

    ExtendedBatchQueryCommandCodec(ExtendedBatchQueryCommand<R> cmd) {
        super(cmd);
        this.params = cmd.params();
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        if (this.params.isEmpty() && this.statement.paramDesc.paramDefinitions().length > 0) {
            this.completionHandler.handle((Object)CommandResponse.failure((String)"Statement parameter is not set because of the empty batch param list"));
            return;
        }
        this.doExecuteBatch();
    }

    @Override
    protected void handleSingleResultsetDecodingCompleted(int serverStatusFlags, int affectedRows, int lastInsertId) {
        super.handleSingleResultsetDecodingCompleted(serverStatusFlags, affectedRows, lastInsertId);
        this.doExecuteBatch();
    }

    @Override
    protected boolean isDecodingCompleted(int serverStatusFlags) {
        return super.isDecodingCompleted(serverStatusFlags) && this.batchIdx == this.params.size();
    }

    private void doExecuteBatch() {
        if (this.batchIdx < this.params.size()) {
            this.sequenceId = 0;
            Tuple param = this.params.get(this.batchIdx);
            this.sendStatementExecuteCommand(this.statement.statementId, this.statement.paramDesc.paramDefinitions(), (byte)1, param, (byte)0);
            ++this.batchIdx;
        }
    }
}

