/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.DecoderException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.NetSocketInternal;
import io.vertx.mysqlclient.SslMode;
import io.vertx.mysqlclient.impl.InitiateSslHandler;
import io.vertx.mysqlclient.impl.codec.MySQLCodec;
import io.vertx.mysqlclient.impl.command.InitialHandshakeCommand;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SocketConnectionBase;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.util.Map;

public class MySQLSocketConnection
extends SocketConnectionBase {
    private MySQLCodec codec;

    public MySQLSocketConnection(NetSocketInternal socket, boolean cachePreparedStatements, int preparedStatementCacheSize, int preparedStatementCacheSqlLimit, Context context) {
        super(socket, cachePreparedStatements, preparedStatementCacheSize, preparedStatementCacheSqlLimit, 1, context);
    }

    void sendStartupMessage(String username, String password, String database, String collation, boolean useAffectedRows, Buffer serverRsaPublicKey, Map<String, String> properties, SslMode sslMode, Handler<? super CommandResponse<Connection>> completionHandler) {
        InitialHandshakeCommand cmd = new InitialHandshakeCommand(this, username, password, database, collation, useAffectedRows, serverRsaPublicKey, properties, sslMode);
        cmd.handler = completionHandler;
        this.schedule(cmd);
    }

    public void init() {
        this.codec = new MySQLCodec(this);
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        pipeline.addBefore("handler", "codec", (ChannelHandler)this.codec);
        super.init();
    }

    public void upgradeToSSLConnection(Handler<AsyncResult<Void>> completionHandler) {
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        Promise upgradePromise = Promise.promise();
        upgradePromise.future().setHandler(ar -> {
            if (ar.succeeded()) {
                completionHandler.handle((Object)Future.succeededFuture());
            } else {
                Throwable cause = ar.cause();
                if (cause instanceof DecoderException) {
                    DecoderException err = (DecoderException)cause;
                    cause = err.getCause();
                }
                completionHandler.handle((Object)Future.failedFuture((Throwable)cause));
            }
        });
        pipeline.addFirst("initiate-ssl-handler", (ChannelHandler)new InitiateSslHandler(this, (Promise<Void>)upgradePromise));
    }
}

