/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.mysqlclient.impl.codec.AuthenticationCommandBaseCodec;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.command.ChangeUserCommand;
import io.vertx.mysqlclient.impl.util.BufferUtils;
import io.vertx.mysqlclient.impl.util.CachingSha2Authenticator;
import io.vertx.mysqlclient.impl.util.Native41Authenticator;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

class ChangeUserCommandCodec
extends AuthenticationCommandBaseCodec<Void, ChangeUserCommand> {
    ChangeUserCommandCodec(ChangeUserCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        this.sendChangeUserCommand();
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength) {
        short header = payload.getUnsignedByte(payload.readerIndex());
        switch (header) {
            case 254: {
                this.handleAuthSwitchRequest(((ChangeUserCommand)this.cmd).password().getBytes(), payload);
                break;
            }
            case 1: {
                this.handleAuthMoreData(((ChangeUserCommand)this.cmd).password().getBytes(), payload);
                break;
            }
            case 0: {
                this.completionHandler.handle((Object)CommandResponse.success(null));
                break;
            }
            case 255: {
                this.handleErrorPacketPayload(payload);
            }
        }
    }

    private void handleAuthSwitchRequest(byte[] password, ByteBuf payload) {
        byte[] scrambledPassword;
        payload.skipBytes(1);
        String pluginName = BufferUtils.readNullTerminatedString(payload, StandardCharsets.UTF_8);
        this.authPluginData = new byte[20];
        payload.readBytes(this.authPluginData);
        switch (pluginName) {
            case "mysql_native_password": {
                scrambledPassword = Native41Authenticator.encode(password, this.authPluginData);
                break;
            }
            case "caching_sha2_password": {
                scrambledPassword = CachingSha2Authenticator.encode(password, this.authPluginData);
                break;
            }
            default: {
                this.completionHandler.handle((Object)CommandResponse.failure((Throwable)new UnsupportedOperationException("Unsupported authentication method: " + pluginName)));
                return;
            }
        }
        this.sendBytesAsPacket(scrambledPassword);
    }

    private void sendChangeUserCommand() {
        Map<String, String> clientConnectionAttributes;
        ByteBuf packet = this.allocateBuffer();
        int packetStartIdx = packet.writerIndex();
        packet.writeMediumLE(0);
        packet.writeByte(this.sequenceId);
        packet.writeByte(17);
        BufferUtils.writeNullTerminatedString(packet, ((ChangeUserCommand)this.cmd).username(), StandardCharsets.UTF_8);
        String password = ((ChangeUserCommand)this.cmd).password();
        if (password.isEmpty()) {
            packet.writeByte(0);
        } else {
            packet.writeByte(password.length());
            packet.writeCharSequence((CharSequence)password, StandardCharsets.UTF_8);
        }
        BufferUtils.writeNullTerminatedString(packet, ((ChangeUserCommand)this.cmd).database(), StandardCharsets.UTF_8);
        MySQLCollation collation = MySQLCollation.valueOfName(((ChangeUserCommand)this.cmd).collation());
        int collationId = collation.collationId();
        this.encoder.charset = Charset.forName(collation.mappedJavaCharsetName());
        packet.writeShortLE(collationId);
        if ((this.encoder.clientCapabilitiesFlag & 0x80000) != 0) {
            BufferUtils.writeNullTerminatedString(packet, "mysql_native_password", StandardCharsets.UTF_8);
        }
        if ((clientConnectionAttributes = ((ChangeUserCommand)this.cmd).connectionAttributes()) != null && !clientConnectionAttributes.isEmpty()) {
            this.encoder.clientCapabilitiesFlag |= 0x100000;
            this.encodeConnectionAttributes(clientConnectionAttributes, packet);
        }
        int lenOfPayload = packet.writerIndex() - packetStartIdx - 4;
        packet.setMediumLE(packetStartIdx, lenOfPayload);
        this.sendPacket(packet, lenOfPayload);
    }
}

