/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.sqlclient.data.Numeric;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;

public enum DataType {
    INT1(1, Byte.class, Byte.class),
    INT2(2, Short.class, Short.class),
    INT3(9, Integer.class, Integer.class),
    INT4(3, Integer.class, Integer.class),
    INT8(8, Long.class, Long.class),
    DOUBLE(5, Double.class, Double.class),
    FLOAT(4, Float.class, Float.class),
    NUMERIC(246, Numeric.class, Numeric.class),
    STRING(254, Buffer.class, String.class),
    VARSTRING(253, Buffer.class, String.class),
    TINYBLOB(249, Buffer.class, String.class),
    BLOB(252, Buffer.class, String.class),
    MEDIUMBLOB(250, Buffer.class, String.class),
    LONGBLOB(251, Buffer.class, String.class),
    DATE(10, LocalDate.class, LocalDate.class),
    TIME(11, Duration.class, Duration.class),
    DATETIME(12, LocalDateTime.class, LocalDateTime.class),
    YEAR(13, Short.class, Short.class),
    TIMESTAMP(7, LocalDateTime.class, LocalDateTime.class),
    NULL(6, Object.class, Object.class);

    private static IntObjectMap<DataType> idToDataType;
    public final int id;
    public final Class<?> binaryType;
    public final Class<?> textType;

    private DataType(int id, Class<?> binaryType, Class<?> textType) {
        this.id = id;
        this.binaryType = binaryType;
        this.textType = textType;
    }

    public static DataType valueOf(int value) {
        DataType dataType = (DataType)((Object)idToDataType.get(value));
        if (dataType == null) {
            return null;
        }
        return dataType;
    }

    static {
        idToDataType = new IntObjectHashMap();
        for (DataType dataType : DataType.values()) {
            idToDataType.put(dataType.id, (Object)dataType);
        }
    }
}

