/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderException;
import io.vertx.core.buffer.Buffer;
import io.vertx.mysqlclient.impl.codec.DataType;
import io.vertx.mysqlclient.impl.util.BufferUtils;
import io.vertx.sqlclient.data.Numeric;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;

class DataTypeCodec {
    public static final Object REFUSED_SENTINEL = new Object();
    private static final DateTimeFormatter DATETIME_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).toFormatter();

    DataTypeCodec() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object decodeText(DataType dataType, Charset charset, int columnDefinitionFlags, ByteBuf buffer) {
        int length = (int)BufferUtils.readLengthEncodedInteger(buffer);
        int index = buffer.readerIndex();
        try {
            switch (dataType) {
                case INT1: {
                    Byte by = DataTypeCodec.textDecodeInt1(charset, buffer, index, length);
                    return by;
                }
                case INT2: 
                case YEAR: {
                    Short s = DataTypeCodec.textDecodeInt2(charset, buffer, index, length);
                    return s;
                }
                case INT3: {
                    Integer n = DataTypeCodec.textDecodeInt3(charset, buffer, index, length);
                    return n;
                }
                case INT4: {
                    Integer n = DataTypeCodec.textDecodeInt4(charset, buffer, index, length);
                    return n;
                }
                case INT8: {
                    Long l = DataTypeCodec.textDecodeInt8(charset, buffer, index, length);
                    return l;
                }
                case FLOAT: {
                    Float f = DataTypeCodec.textDecodeFloat(charset, buffer, index, length);
                    return f;
                }
                case DOUBLE: {
                    Double d = DataTypeCodec.textDecodeDouble(charset, buffer, index, length);
                    return d;
                }
                case NUMERIC: {
                    Number number = DataTypeCodec.textDecodeNUMERIC(charset, buffer, index, length);
                    return number;
                }
                case DATE: {
                    LocalDate localDate = DataTypeCodec.textDecodeDate(charset, buffer, index, length);
                    return localDate;
                }
                case TIME: {
                    Duration duration = DataTypeCodec.textDecodeTime(charset, buffer, index, length);
                    return duration;
                }
                case DATETIME: 
                case TIMESTAMP: {
                    LocalDateTime localDateTime = DataTypeCodec.textDecodeDateTime(charset, buffer, index, length);
                    return localDateTime;
                }
            }
            Object object = DataTypeCodec.textDecodeBlobOrText(charset, columnDefinitionFlags, buffer, index, length);
            return object;
        }
        finally {
            buffer.readerIndex(index + length);
        }
    }

    static void encodeBinary(DataType dataType, Object value, ByteBuf buffer) {
        switch (dataType) {
            case INT1: {
                if (value instanceof Boolean) {
                    value = (Boolean)value != false ? Integer.valueOf(1) : Integer.valueOf(0);
                }
                DataTypeCodec.binaryEncodeInt1((Number)value, buffer);
                break;
            }
            case INT2: {
                DataTypeCodec.binaryEncodeInt2((Number)value, buffer);
                break;
            }
            case INT3: {
                DataTypeCodec.binaryEncodeInt3((Number)value, buffer);
                break;
            }
            case INT4: {
                DataTypeCodec.binaryEncodeInt4((Number)value, buffer);
                break;
            }
            case INT8: {
                DataTypeCodec.binaryEncodeInt8((Number)value, buffer);
                break;
            }
            case FLOAT: {
                DataTypeCodec.binaryEncodeFloat((Number)value, buffer);
                break;
            }
            case DOUBLE: {
                DataTypeCodec.binaryEncodeDouble((Number)value, buffer);
                break;
            }
            case NUMERIC: {
                DataTypeCodec.binaryEncodeNumeric((Numeric)value, buffer);
                break;
            }
            case BLOB: {
                DataTypeCodec.binaryEncodeBlob((Buffer)value, buffer);
                break;
            }
            case DATE: {
                DataTypeCodec.binaryEncodeDate((LocalDate)value, buffer);
                break;
            }
            case TIME: {
                DataTypeCodec.binaryEncodeTime((Duration)value, buffer);
                break;
            }
            case DATETIME: {
                DataTypeCodec.binaryEncodeDatetime((LocalDateTime)value, buffer);
                break;
            }
            default: {
                DataTypeCodec.binaryEncodeText(String.valueOf(value), buffer);
            }
        }
    }

    static Object decodeBinary(DataType dataType, Charset charset, int columnDefinitionFlags, ByteBuf buffer) {
        switch (dataType) {
            case INT1: {
                return DataTypeCodec.binaryDecodeInt1(buffer);
            }
            case INT2: 
            case YEAR: {
                return DataTypeCodec.binaryDecodeInt2(buffer);
            }
            case INT3: {
                return DataTypeCodec.binaryDecodeInt3(buffer);
            }
            case INT4: {
                return DataTypeCodec.binaryDecodeInt4(buffer);
            }
            case INT8: {
                return DataTypeCodec.binaryDecodeInt8(buffer);
            }
            case FLOAT: {
                return DataTypeCodec.binaryDecodeFloat(buffer);
            }
            case DOUBLE: {
                return DataTypeCodec.binaryDecodeDouble(buffer);
            }
            case NUMERIC: {
                return DataTypeCodec.binaryDecodeNumeric(charset, buffer);
            }
            case DATE: {
                return DataTypeCodec.binaryDecodeDate(buffer);
            }
            case TIME: {
                return DataTypeCodec.binaryDecodeTime(buffer);
            }
            case DATETIME: 
            case TIMESTAMP: {
                return DataTypeCodec.binaryDecodeDatetime(buffer);
            }
        }
        return DataTypeCodec.binaryDecodeBlobOrText(charset, columnDefinitionFlags, buffer);
    }

    public static Object prepare(DataType type, Object value) {
        switch (type) {
            default: 
        }
        Class<?> javaType = type.binaryType;
        return value == null || javaType.isInstance(value) ? value : REFUSED_SENTINEL;
    }

    private static void binaryEncodeInt1(Number value, ByteBuf buffer) {
        buffer.writeByte((int)value.byteValue());
    }

    private static void binaryEncodeInt2(Number value, ByteBuf buffer) {
        buffer.writeShortLE(value.intValue());
    }

    private static void binaryEncodeInt3(Number value, ByteBuf buffer) {
        buffer.writeMediumLE(value.intValue());
    }

    private static void binaryEncodeInt4(Number value, ByteBuf buffer) {
        buffer.writeIntLE(value.intValue());
    }

    private static void binaryEncodeInt8(Number value, ByteBuf buffer) {
        buffer.writeLongLE(value.longValue());
    }

    private static void binaryEncodeFloat(Number value, ByteBuf buffer) {
        buffer.writeFloatLE(value.floatValue());
    }

    private static void binaryEncodeDouble(Number value, ByteBuf buffer) {
        buffer.writeDoubleLE(value.doubleValue());
    }

    private static void binaryEncodeNumeric(Numeric value, ByteBuf buffer) {
        BufferUtils.writeLengthEncodedString(buffer, value.toString());
    }

    private static void binaryEncodeText(String value, ByteBuf buffer) {
        BufferUtils.writeLengthEncodedString(buffer, value);
    }

    private static void binaryEncodeBlob(Buffer value, ByteBuf buffer) {
        BufferUtils.writeLengthEncodedInteger(buffer, value.length());
        buffer.writeBytes(value.getByteBuf());
    }

    private static void binaryEncodeDate(LocalDate value, ByteBuf buffer) {
        buffer.writeByte(4);
        buffer.writeShortLE(value.getYear());
        buffer.writeByte(value.getMonthValue());
        buffer.writeByte(value.getDayOfMonth());
    }

    private static void binaryEncodeTime(Duration value, ByteBuf buffer) {
        int microSecond;
        long secondsOfDuration = value.getSeconds();
        int nanosOfDuration = value.getNano();
        if (secondsOfDuration == 0L && nanosOfDuration == 0) {
            buffer.writeByte(0);
            return;
        }
        int isNegative = 0;
        if (secondsOfDuration < 0L) {
            isNegative = 1;
            secondsOfDuration = -secondsOfDuration;
        }
        int days = (int)(secondsOfDuration / 86400L);
        int secondsOfADay = (int)(secondsOfDuration % 86400L);
        int hour = secondsOfADay / 3600;
        int minute = secondsOfADay % 3600 / 60;
        int second = secondsOfADay % 60;
        if (nanosOfDuration == 0) {
            buffer.writeByte(8);
            buffer.writeByte(isNegative);
            buffer.writeIntLE(days);
            buffer.writeByte(hour);
            buffer.writeByte(minute);
            buffer.writeByte(second);
            return;
        }
        if (isNegative == 1 && nanosOfDuration > 0) {
            --second;
            microSecond = (1000000000 - nanosOfDuration) / 1000;
        } else {
            microSecond = nanosOfDuration / 1000;
        }
        buffer.writeByte(12);
        buffer.writeByte(isNegative);
        buffer.writeIntLE(days);
        buffer.writeByte(hour);
        buffer.writeByte(minute);
        buffer.writeByte(second);
        buffer.writeIntLE(microSecond);
    }

    private static void binaryEncodeDatetime(LocalDateTime value, ByteBuf buffer) {
        int year = value.getYear();
        int month = value.getMonthValue();
        int day = value.getDayOfMonth();
        int hour = value.getHour();
        int minute = value.getMinute();
        int second = value.getSecond();
        int microsecond = value.getNano() / 1000;
        if (hour == 0 && minute == 0 && second == 0 && microsecond == 0) {
            buffer.writeByte(4);
            buffer.writeShortLE(year);
            buffer.writeByte(month);
            buffer.writeByte(day);
        } else if (microsecond == 0) {
            buffer.writeByte(7);
            buffer.writeShortLE(year);
            buffer.writeByte(month);
            buffer.writeByte(day);
            buffer.writeByte(hour);
            buffer.writeByte(minute);
            buffer.writeByte(second);
        } else {
            buffer.writeByte(11);
            buffer.writeShortLE(year);
            buffer.writeByte(month);
            buffer.writeByte(day);
            buffer.writeByte(hour);
            buffer.writeByte(minute);
            buffer.writeByte(second);
            buffer.writeIntLE(microsecond);
        }
    }

    private static Byte binaryDecodeInt1(ByteBuf buffer) {
        return buffer.readByte();
    }

    private static Short binaryDecodeInt2(ByteBuf buffer) {
        return buffer.readShortLE();
    }

    private static Integer binaryDecodeInt3(ByteBuf buffer) {
        return buffer.readIntLE();
    }

    private static Integer binaryDecodeInt4(ByteBuf buffer) {
        return buffer.readIntLE();
    }

    private static Long binaryDecodeInt8(ByteBuf buffer) {
        return buffer.readLongLE();
    }

    private static Float binaryDecodeFloat(ByteBuf buffer) {
        return Float.valueOf(buffer.readFloatLE());
    }

    private static Double binaryDecodeDouble(ByteBuf buffer) {
        return buffer.readDoubleLE();
    }

    private static Numeric binaryDecodeNumeric(Charset charset, ByteBuf buffer) {
        return Numeric.parse((String)BufferUtils.readLengthEncodedString(buffer, charset));
    }

    private static Object binaryDecodeBlobOrText(Charset charset, int columnDefinitionFlags, ByteBuf buffer) {
        if (DataTypeCodec.isBinaryField(columnDefinitionFlags)) {
            return DataTypeCodec.binaryDecodeBlob(buffer);
        }
        return DataTypeCodec.binaryDecodeText(charset, buffer);
    }

    private static Buffer binaryDecodeBlob(ByteBuf buffer) {
        int len = (int)BufferUtils.readLengthEncodedInteger(buffer);
        Buffer target = Buffer.buffer((int)len);
        target.appendBuffer(Buffer.buffer((ByteBuf)buffer.slice(buffer.readerIndex(), len)));
        buffer.skipBytes(len);
        return target;
    }

    private static String binaryDecodeText(Charset charset, ByteBuf buffer) {
        return BufferUtils.readLengthEncodedString(buffer, charset);
    }

    private static LocalDateTime binaryDecodeDatetime(ByteBuf buffer) {
        if (buffer.readableBytes() == 0) {
            return null;
        }
        byte length = buffer.readByte();
        if (length == 0) {
            return null;
        }
        short year = buffer.readShortLE();
        byte month = buffer.readByte();
        byte day = buffer.readByte();
        if (length == 4) {
            return LocalDateTime.of((int)year, month, (int)day, 0, 0, 0);
        }
        byte hour = buffer.readByte();
        byte minute = buffer.readByte();
        byte second = buffer.readByte();
        if (length == 11) {
            int microsecond = buffer.readIntLE();
            return LocalDateTime.of((int)year, month, (int)day, (int)hour, (int)minute, (int)second, microsecond * 1000);
        }
        if (length == 7) {
            return LocalDateTime.of((int)year, month, (int)day, (int)hour, (int)minute, (int)second, 0);
        }
        throw new DecoderException("Invalid Datetime");
    }

    private static LocalDate binaryDecodeDate(ByteBuf buffer) {
        return DataTypeCodec.binaryDecodeDatetime(buffer).toLocalDate();
    }

    private static Duration binaryDecodeTime(ByteBuf buffer) {
        byte length = buffer.readByte();
        if (length == 0) {
            return Duration.ZERO;
        }
        boolean isNegative = buffer.readByte() == 1;
        int days = buffer.readIntLE();
        byte hour = buffer.readByte();
        byte minute = buffer.readByte();
        byte second = buffer.readByte();
        if (isNegative) {
            days = -days;
            hour = -hour;
            minute = -minute;
            second = -second;
        }
        if (length == 8) {
            return Duration.ofDays(days).plusHours(hour).plusMinutes(minute).plusSeconds(second);
        }
        if (length == 12) {
            long microsecond = buffer.readUnsignedIntLE();
            if (isNegative) {
                microsecond = -microsecond;
            }
            return Duration.ofDays(days).plusHours(hour).plusMinutes(minute).plusSeconds(second).plusNanos(microsecond * 1000L);
        }
        throw new DecoderException("Invalid time format");
    }

    private static Byte textDecodeInt1(Charset charset, ByteBuf buffer, int index, int length) {
        return Byte.parseByte(buffer.toString(index, length, charset));
    }

    private static Short textDecodeInt2(Charset charset, ByteBuf buffer, int index, int length) {
        return Short.parseShort(buffer.toString(index, length, charset));
    }

    private static Integer textDecodeInt3(Charset charset, ByteBuf buffer, int index, int length) {
        return Integer.parseInt(buffer.toString(index, length, charset));
    }

    private static Integer textDecodeInt4(Charset charset, ByteBuf buffer, int index, int length) {
        return Integer.parseInt(buffer.toString(index, length, charset));
    }

    private static Long textDecodeInt8(Charset charset, ByteBuf buffer, int index, int length) {
        return Long.parseLong(buffer.toString(index, length, charset));
    }

    private static Float textDecodeFloat(Charset charset, ByteBuf buffer, int index, int length) {
        return Float.valueOf(Float.parseFloat(buffer.toString(index, length, charset)));
    }

    private static Double textDecodeDouble(Charset charset, ByteBuf buffer, int index, int length) {
        return Double.parseDouble(buffer.toString(index, length, charset));
    }

    private static Number textDecodeNUMERIC(Charset charset, ByteBuf buff, int index, int length) {
        return Numeric.parse((String)buff.toString(index, length, charset));
    }

    private static Object textDecodeBlobOrText(Charset charset, int columnDefinitionFlags, ByteBuf buffer, int index, int length) {
        if (DataTypeCodec.isBinaryField(columnDefinitionFlags)) {
            return DataTypeCodec.textDecodeBlob(buffer, index, length);
        }
        return DataTypeCodec.textDecodeText(charset, buffer, index, length);
    }

    private static Buffer textDecodeBlob(ByteBuf buffer, int index, int length) {
        ByteBuf copy = Unpooled.buffer((int)length);
        copy.writeBytes(buffer, index, length);
        return Buffer.buffer((ByteBuf)copy);
    }

    private static String textDecodeText(Charset charset, ByteBuf buffer, int index, int length) {
        return buffer.toString(index, length, charset);
    }

    private static LocalDate textDecodeDate(Charset charset, ByteBuf buffer, int index, int length) {
        String cs = buffer.toString(index, length, charset);
        return LocalDate.parse(cs);
    }

    private static Duration textDecodeTime(Charset charset, ByteBuf buffer, int index, int length) {
        String[] timeElements;
        boolean isNegative;
        String timeString = buffer.toString(index, length, charset);
        boolean bl = isNegative = timeString.charAt(0) == '-';
        if (isNegative) {
            timeString = timeString.substring(1);
        }
        if ((timeElements = timeString.split(":")).length != 3) {
            throw new DecoderException("Invalid time format");
        }
        int hour = Integer.parseInt(timeElements[0]);
        int minute = Integer.parseInt(timeElements[1]);
        int second = Integer.parseInt(timeElements[2].substring(0, 2));
        long nanos = 0L;
        if (timeElements[2].length() > 2) {
            double fractionalSecondsPart = Double.parseDouble("0." + timeElements[2].substring(3));
            nanos = (long)(1.0E9 * fractionalSecondsPart);
        }
        if (isNegative) {
            return Duration.ofHours(-hour).minusMinutes(minute).minusSeconds(second).minusNanos(nanos);
        }
        return Duration.ofHours(hour).plusMinutes(minute).plusSeconds(second).plusNanos(nanos);
    }

    private static LocalDateTime textDecodeDateTime(Charset charset, ByteBuf buffer, int index, int length) {
        String cs = buffer.toString(charset);
        if (cs.equals("0000-00-00 00:00:00")) {
            return null;
        }
        return LocalDateTime.parse(cs, DATETIME_FORMAT);
    }

    private static boolean isBinaryField(int columnDefinitionFlags) {
        return (columnDefinitionFlags & 0x80) != 0;
    }
}

