/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.ArrayTuple;
import io.vertx.sqlclient.impl.RowDesc;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.UUID;

public class MySQLRowImpl
extends ArrayTuple
implements Row {
    private final RowDesc rowDesc;

    public MySQLRowImpl(RowDesc rowDesc) {
        super(rowDesc.columnNames().size());
        this.rowDesc = rowDesc;
    }

    public <T> T get(Class<T> type, int pos) {
        if (type == Boolean.class) {
            return type.cast(this.getBoolean(pos));
        }
        if (type == Byte.class) {
            return type.cast(this.getByte(pos));
        }
        if (type == Short.class) {
            return type.cast(this.getShort(pos));
        }
        if (type == Integer.class) {
            return type.cast(this.getInteger(pos));
        }
        if (type == Long.class) {
            return type.cast(this.getLong(pos));
        }
        if (type == Float.class) {
            return type.cast(this.getFloat(pos));
        }
        if (type == Double.class) {
            return type.cast(this.getDouble(pos));
        }
        if (type == Numeric.class) {
            return type.cast(this.getNumeric(pos));
        }
        if (type == String.class) {
            return type.cast(this.getString(pos));
        }
        if (type == Buffer.class) {
            return type.cast(this.getBuffer(pos));
        }
        if (type == LocalDate.class) {
            return type.cast(this.getLocalDate(pos));
        }
        if (type == LocalDateTime.class) {
            return type.cast(this.getLocalDateTime(pos));
        }
        if (type == Duration.class) {
            return type.cast(this.getDuration(pos));
        }
        if (type == JsonObject.class) {
            return type.cast(this.getJsonObject(pos));
        }
        if (type == JsonArray.class) {
            return type.cast(this.getJsonArray(pos));
        }
        throw new UnsupportedOperationException("Unsupported type " + type.getName());
    }

    public <T> T[] getValues(Class<T> type, int idx) {
        throw new UnsupportedOperationException();
    }

    public String getColumnName(int pos) {
        List columnNames = this.rowDesc.columnNames();
        return pos < 0 || columnNames.size() - 1 < pos ? null : (String)columnNames.get(pos);
    }

    public int getColumnIndex(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.rowDesc.columnNames().indexOf(name);
    }

    public Object getValue(String name) {
        int pos = this.rowDesc.columnIndex(name);
        return pos == -1 ? null : this.getValue(pos);
    }

    public Boolean getBoolean(String name) {
        int pos = this.rowDesc.columnIndex(name);
        return pos == -1 ? null : this.getBoolean(pos);
    }

    public Short getShort(String name) {
        int pos = this.rowDesc.columnIndex(name);
        return pos == -1 ? null : this.getShort(pos);
    }

    public Integer getInteger(String name) {
        int pos = this.rowDesc.columnIndex(name);
        return pos == -1 ? null : this.getInteger(pos);
    }

    public Long getLong(String name) {
        int pos = this.rowDesc.columnIndex(name);
        return pos == -1 ? null : this.getLong(pos);
    }

    public Float getFloat(String name) {
        int pos = this.rowDesc.columnIndex(name);
        return pos == -1 ? null : this.getFloat(pos);
    }

    public Double getDouble(String name) {
        int pos = this.rowDesc.columnIndex(name);
        return pos == -1 ? null : this.getDouble(pos);
    }

    public Numeric getNumeric(String name) {
        int pos = this.rowDesc.columnIndex(name);
        return pos == -1 ? null : this.getNumeric(pos);
    }

    public String getString(String name) {
        int pos = this.rowDesc.columnIndex(name);
        return pos == -1 ? null : this.getString(pos);
    }

    public Buffer getBuffer(String name) {
        int pos = this.rowDesc.columnIndex(name);
        return pos == -1 ? null : this.getBuffer(pos);
    }

    public Temporal getTemporal(String name) {
        throw new UnsupportedOperationException();
    }

    public LocalDate getLocalDate(String name) {
        int pos = this.rowDesc.columnIndex(name);
        return pos == -1 ? null : this.getLocalDate(pos);
    }

    public LocalTime getLocalTime(String name) {
        throw new UnsupportedOperationException();
    }

    public LocalDateTime getLocalDateTime(String name) {
        int pos = this.rowDesc.columnIndex(name);
        return pos == -1 ? null : this.getLocalDateTime(pos);
    }

    public OffsetTime getOffsetTime(String name) {
        throw new UnsupportedOperationException();
    }

    public OffsetDateTime getOffsetDateTime(String name) {
        throw new UnsupportedOperationException();
    }

    public UUID getUUID(String name) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String name) {
        throw new UnsupportedOperationException();
    }

    public Integer[] getIntegerArray(String name) {
        throw new UnsupportedOperationException();
    }

    public Boolean[] getBooleanArray(String name) {
        throw new UnsupportedOperationException();
    }

    public Short[] getShortArray(String name) {
        throw new UnsupportedOperationException();
    }

    public Long[] getLongArray(String name) {
        throw new UnsupportedOperationException();
    }

    public Float[] getFloatArray(String name) {
        throw new UnsupportedOperationException();
    }

    public Double[] getDoubleArray(String name) {
        throw new UnsupportedOperationException();
    }

    public String[] getStringArray(String name) {
        throw new UnsupportedOperationException();
    }

    public LocalDate[] getLocalDateArray(String name) {
        throw new UnsupportedOperationException();
    }

    public LocalTime[] getLocalTimeArray(String name) {
        throw new UnsupportedOperationException();
    }

    public OffsetTime[] getOffsetTimeArray(String name) {
        throw new UnsupportedOperationException();
    }

    public LocalDateTime[] getLocalDateTimeArray(String name) {
        throw new UnsupportedOperationException();
    }

    public OffsetDateTime[] getOffsetDateTimeArray(String name) {
        throw new UnsupportedOperationException();
    }

    public Buffer[] getBufferArray(String name) {
        throw new UnsupportedOperationException();
    }

    public UUID[] getUUIDArray(String name) {
        throw new UnsupportedOperationException();
    }

    public Boolean getBoolean(int pos) {
        Object val = this.get(pos);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue() != 0;
        }
        return null;
    }

    public Numeric getNumeric(int pos) {
        Object val = this.get(pos);
        if (val instanceof Numeric) {
            return (Numeric)val;
        }
        if (val instanceof Number) {
            return Numeric.parse((String)val.toString());
        }
        return null;
    }

    private Byte getByte(int pos) {
        Object val = this.get(pos);
        if (val instanceof Byte) {
            return (Byte)val;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        return null;
    }

    private Duration getDuration(int pos) {
        Object val = this.get(pos);
        if (val instanceof Duration) {
            return (Duration)val;
        }
        return null;
    }

    private JsonObject getJsonObject(int pos) {
        Object val = this.get(pos);
        if (val instanceof JsonObject) {
            return (JsonObject)val;
        }
        return null;
    }

    private JsonArray getJsonArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof JsonArray) {
            return (JsonArray)val;
        }
        return null;
    }
}

