/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.vertx.mysqlclient.impl.codec.DataType;

final class ColumnDefinition {
    private final String catalog;
    private final String schema;
    private final String table;
    private final String orgTable;
    private final String name;
    private final String orgName;
    private final int characterSet;
    private final long columnLength;
    private DataType type;
    private final int flags;
    private final byte decimals;

    ColumnDefinition(String catalog, String schema, String table, String orgTable, String name, String orgName, int characterSet, long columnLength, DataType type, int flags, byte decimals) {
        this.catalog = catalog;
        this.schema = schema;
        this.table = table;
        this.orgTable = orgTable;
        this.name = name;
        this.orgName = orgName;
        this.characterSet = characterSet;
        this.columnLength = columnLength;
        this.type = type;
        this.flags = flags;
        this.decimals = decimals;
    }

    String catalog() {
        return this.catalog;
    }

    String schema() {
        return this.schema;
    }

    String table() {
        return this.table;
    }

    String orgTable() {
        return this.orgTable;
    }

    String name() {
        return this.name;
    }

    String orgName() {
        return this.orgName;
    }

    int characterSet() {
        return this.characterSet;
    }

    long columnLength() {
        return this.columnLength;
    }

    DataType getType() {
        return this.type;
    }

    public void setType(DataType type) {
        this.type = type;
    }

    int flags() {
        return this.flags;
    }

    byte decimals() {
        return this.decimals;
    }

    public String toString() {
        return "ColumnDefinition{catalog='" + this.catalog + '\'' + ", schema='" + this.schema + '\'' + ", table='" + this.table + '\'' + ", orgTable='" + this.orgTable + '\'' + ", name='" + this.name + '\'' + ", orgName='" + this.orgName + '\'' + ", characterSet=" + this.characterSet + ", columnLength=" + this.columnLength + ", type=" + (Object)((Object)this.type) + ", flags=" + this.flags + ", decimals=" + this.decimals + '}';
    }

    static final class ColumnDefinitionFlags {
        static final int NOT_NULL_FLAG = 1;
        static final int PRI_KEY_FLAG = 2;
        static final int UNIQUE_KEY_FLAG = 4;
        static final int MULTIPLE_KEY_FLAG = 8;
        static final int BLOB_FLAG = 16;
        static final int UNSIGNED_FLAG = 32;
        static final int ZEROFILL_FLAG = 64;
        static final int BINARY_FLAG = 128;
        static final int ENUM_FLAG = 256;
        static final int AUTO_INCREMENT_FLAG = 512;
        static final int TIMESTAMP_FLAG = 1024;
        static final int SET_FLAG = 2048;
        static final int NO_DEFAULT_VALUE_FLAG = 4096;
        static final int ON_UPDATE_NOW_FLAG = 8192;
        static final int NUM_FLAG = 32768;
        static final int PART_KEY_FLAG = 16384;
        static final int GROUP_FLAG = 32768;
        static final int UNIQUE_FLAG = 65536;
        static final int BINCMP_FLAG = 131072;
        static final int GET_FIXED_FIELDS_FLAG = 262144;
        static final int FIELD_IN_PART_FUNC_FLAG = 524288;
        static final int FIELD_IN_ADD_INDEX = 0x100000;
        static final int FIELD_IS_RENAMED = 0x200000;
        static final int FIELD_FLAGS_STORAGE_MEDIA = 22;
        static final int FIELD_FLAGS_STORAGE_MEDIA_MASK = 0xC00000;
        static final int FIELD_FLAGS_COLUMN_FORMAT = 24;
        static final int FIELD_FLAGS_COLUMN_FORMAT_MASK = 0x3000000;
        static final int FIELD_IS_DROPPED = 0x4000000;
        static final int EXPLICIT_NULL_FLAG = 0x8000000;
        static final int FIELD_IS_MARKED = 0x10000000;

        ColumnDefinitionFlags() {
        }
    }

    static final class ColumnType {
        static final int MYSQL_TYPE_DECIMAL = 0;
        static final int MYSQL_TYPE_TINY = 1;
        static final int MYSQL_TYPE_SHORT = 2;
        static final int MYSQL_TYPE_LONG = 3;
        static final int MYSQL_TYPE_FLOAT = 4;
        static final int MYSQL_TYPE_DOUBLE = 5;
        static final int MYSQL_TYPE_NULL = 6;
        static final int MYSQL_TYPE_TIMESTAMP = 7;
        static final int MYSQL_TYPE_LONGLONG = 8;
        static final int MYSQL_TYPE_INT24 = 9;
        static final int MYSQL_TYPE_DATE = 10;
        static final int MYSQL_TYPE_TIME = 11;
        static final int MYSQL_TYPE_DATETIME = 12;
        static final int MYSQL_TYPE_YEAR = 13;
        static final int MYSQL_TYPE_VARCHAR = 15;
        static final int MYSQL_TYPE_BIT = 16;
        static final int MYSQL_TYPE_JSON = 245;
        static final int MYSQL_TYPE_NEWDECIMAL = 246;
        static final int MYSQL_TYPE_ENUM = 247;
        static final int MYSQL_TYPE_SET = 248;
        static final int MYSQL_TYPE_TINY_BLOB = 249;
        static final int MYSQL_TYPE_MEDIUM_BLOB = 250;
        static final int MYSQL_TYPE_LONG_BLOB = 251;
        static final int MYSQL_TYPE_BLOB = 252;
        static final int MYSQL_TYPE_VAR_STRING = 253;
        static final int MYSQL_TYPE_STRING = 254;
        static final int MYSQL_TYPE_GEOMETRY = 255;
        private static final int MYSQL_TYPE_NEWDATE = 14;
        private static final int MYSQL_TYPE_TIMESTAMP2 = 17;
        private static final int MYSQL_TYPE_DATETIME2 = 18;
        private static final int MYSQL_TYPE_TIME2 = 19;

        ColumnType() {
        }
    }
}

