/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.codec.DataFormat;
import io.vertx.mysqlclient.impl.codec.MySQLPreparedStatement;
import io.vertx.mysqlclient.impl.codec.Packets;
import io.vertx.mysqlclient.impl.codec.QueryCommandBaseCodec;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommandBase;
import java.nio.charset.StandardCharsets;

abstract class ExtendedQueryCommandBaseCodec<R, C extends ExtendedQueryCommandBase<R>>
extends QueryCommandBaseCodec<R, C> {
    protected final MySQLPreparedStatement statement;

    ExtendedQueryCommandBaseCodec(C cmd) {
        super(cmd, DataFormat.BINARY);
        this.statement = (MySQLPreparedStatement)cmd.preparedStatement();
    }

    @Override
    protected void handleInitPacket(ByteBuf payload) {
        short firstByte = payload.getUnsignedByte(payload.readerIndex());
        if (firstByte == 0) {
            Packets.OkPacket okPacket = this.decodeOkPacketPayload(payload, StandardCharsets.UTF_8);
            this.handleSingleResultsetDecodingCompleted(okPacket.serverStatusFlags(), okPacket.affectedRows(), okPacket.lastInsertId());
        } else if (firstByte == 255) {
            this.handleErrorPacketPayload(payload);
        } else {
            this.handleResultsetColumnCountPacketBody(payload);
        }
    }
}

