/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.vertx.mysqlclient.impl.codec.ColumnDefinition;
import io.vertx.mysqlclient.impl.codec.DataType;
import io.vertx.mysqlclient.impl.codec.DataTypeCodec;
import io.vertx.sqlclient.impl.ErrorMessageFactory;
import io.vertx.sqlclient.impl.ParamDesc;
import io.vertx.sqlclient.impl.TupleInternal;

class MySQLParamDesc
extends ParamDesc {
    private final ColumnDefinition[] paramDefinitions;
    private boolean sendTypesToServer;

    MySQLParamDesc(ColumnDefinition[] paramDefinitions) {
        this.paramDefinitions = paramDefinitions;
        this.sendTypesToServer = false;
    }

    ColumnDefinition[] paramDefinitions() {
        return this.paramDefinitions;
    }

    public String prepare(TupleInternal values) {
        int paramDescLength;
        int numberOfParameters = values.size();
        if (numberOfParameters != (paramDescLength = this.paramDefinitions.length)) {
            return ErrorMessageFactory.buildWhenArgumentsLengthNotMatched((int)paramDescLength, (int)numberOfParameters);
        }
        boolean reboundParameters = false;
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.getValue(i);
            DataType dataType = DataTypeCodec.inferDataTypeByEncodingValue(value);
            DataType paramDataType = this.paramDefinitions[i].getType();
            if (paramDataType == dataType) continue;
            this.paramDefinitions[i].setType(dataType);
            reboundParameters = true;
        }
        this.sendTypesToServer = reboundParameters;
        return null;
    }

    public boolean sendTypesToServer() {
        return this.sendTypesToServer;
    }
}

