/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.codec.ExtendedQueryCommandBaseCodec;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.codec.MySQLPreparedStatement;
import io.vertx.mysqlclient.impl.datatype.DataType;
import io.vertx.mysqlclient.impl.datatype.DataTypeCodec;
import io.vertx.mysqlclient.impl.protocol.ColumnDefinition;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.ExtendedBatchQueryCommand;
import java.util.List;

class ExtendedBatchQueryCommandCodec<R>
extends ExtendedQueryCommandBaseCodec<R, ExtendedBatchQueryCommand<R>> {
    private List<Tuple> params;
    private int batchIdx = 0;

    ExtendedBatchQueryCommandCodec(ExtendedBatchQueryCommand<R> cmd) {
        super(cmd);
        this.params = cmd.params();
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        if (this.params.isEmpty() && this.statement.paramDesc.paramDefinitions().length > 0) {
            this.completionHandler.handle((Object)CommandResponse.failure((String)"Statement parameter is not set because of the empty batch param list"));
            return;
        }
        this.doExecuteBatch();
    }

    @Override
    protected void handleSingleResultsetDecodingCompleted(int serverStatusFlags, long affectedRows, long lastInsertId) {
        super.handleSingleResultsetDecodingCompleted(serverStatusFlags, affectedRows, lastInsertId);
        this.doExecuteBatch();
    }

    @Override
    protected boolean isDecodingCompleted(int serverStatusFlags) {
        return super.isDecodingCompleted(serverStatusFlags) && this.batchIdx == this.params.size();
    }

    private void doExecuteBatch() {
        if (this.batchIdx < this.params.size()) {
            this.sequenceId = 0;
            Tuple param = this.params.get(this.batchIdx);
            this.sendBatchStatementExecuteCommand(this.statement, param);
            ++this.batchIdx;
        }
    }

    private void sendBatchStatementExecuteCommand(MySQLPreparedStatement statement, Tuple params) {
        ByteBuf packet = this.allocateBuffer();
        int packetStartIdx = packet.writerIndex();
        packet.writeMediumLE(0);
        packet.writeByte(this.sequenceId);
        packet.writeByte(23);
        packet.writeIntLE((int)statement.statementId);
        packet.writeByte(0);
        packet.writeIntLE(1);
        ColumnDefinition[] paramsColumnDefinitions = statement.paramDesc.paramDefinitions();
        int numOfParams = paramsColumnDefinitions.length;
        int bitmapLength = (numOfParams + 7) / 8;
        byte[] nullBitmap = new byte[bitmapLength];
        int pos = packet.writerIndex();
        if (numOfParams > 0) {
            int i;
            packet.writeBytes(nullBitmap);
            packet.writeByte(1);
            for (i = 0; i < params.size(); ++i) {
                Object param = params.getValue(i);
                DataType dataType = DataTypeCodec.inferDataTypeByEncodingValue(param);
                packet.writeByte(dataType.id);
                packet.writeByte(0);
            }
            for (i = 0; i < numOfParams; ++i) {
                Object value = params.getValue(i);
                if (value != null) {
                    DataTypeCodec.encodeBinary(DataTypeCodec.inferDataTypeByEncodingValue(value), value, this.encoder.encodingCharset, packet);
                    continue;
                }
                int n = i / 8;
                nullBitmap[n] = (byte)(nullBitmap[n] | 1 << (i & 7));
            }
            packet.setBytes(pos, nullBitmap);
        }
        int payloadLength = packet.writerIndex() - packetStartIdx - 4;
        packet.setMediumLE(packetStartIdx, payloadLength);
        this.sendPacket(packet, payloadLength);
    }
}

