/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import java.util.ArrayDeque;
import java.util.List;

class MySQLDecoder
extends ByteToMessageDecoder {
    private final ArrayDeque<CommandCodec<?, ?>> inflight;
    private final MySQLEncoder encoder;
    private CompositeByteBuf aggregatedPacketPayload = null;

    MySQLDecoder(ArrayDeque<CommandCodec<?, ?>> inflight, MySQLEncoder encoder) {
        this.inflight = inflight;
        this.encoder = encoder;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() > 4) {
            int packetStartIdx = in.readerIndex();
            int payloadLength = in.readUnsignedMediumLE();
            int sequenceId = in.readUnsignedByte();
            if (payloadLength >= 0xFFFFFF && this.aggregatedPacketPayload == null) {
                this.aggregatedPacketPayload = ctx.alloc().compositeBuffer();
            }
            if (in.readableBytes() >= payloadLength) {
                if (this.aggregatedPacketPayload != null) {
                    this.aggregatedPacketPayload.addComponent(true, in.readRetainedSlice(payloadLength));
                    ++sequenceId;
                    if (payloadLength < 0xFFFFFF) {
                        this.decodePayload((ByteBuf)this.aggregatedPacketPayload, this.aggregatedPacketPayload.readableBytes(), sequenceId);
                        this.aggregatedPacketPayload.release();
                        this.aggregatedPacketPayload = null;
                    }
                } else {
                    this.decodePayload(in.readSlice(payloadLength), payloadLength, sequenceId);
                }
            } else {
                in.readerIndex(packetStartIdx);
            }
        }
    }

    private void decodePayload(ByteBuf payload, int payloadLength, int sequenceId) {
        CommandCodec<?, ?> ctx = this.inflight.peek();
        ctx.sequenceId = sequenceId + 1;
        ctx.decodePayload(payload, payloadLength);
        payload.clear();
    }
}

