/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.vertx.mysqlclient.impl.MySQLSocketConnection;
import io.vertx.mysqlclient.impl.codec.ChangeUserCommandCodec;
import io.vertx.mysqlclient.impl.codec.CloseConnectionCommandCodec;
import io.vertx.mysqlclient.impl.codec.CloseStatementCommandCodec;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.DebugCommandCodec;
import io.vertx.mysqlclient.impl.codec.ExtendedBatchQueryCommandCodec;
import io.vertx.mysqlclient.impl.codec.ExtendedQueryCommandCodec;
import io.vertx.mysqlclient.impl.codec.InitDbCommandCodec;
import io.vertx.mysqlclient.impl.codec.InitialHandshakeCommandCodec;
import io.vertx.mysqlclient.impl.codec.PingCommandCodec;
import io.vertx.mysqlclient.impl.codec.PrepareStatementCodec;
import io.vertx.mysqlclient.impl.codec.ResetConnectionCommandCodec;
import io.vertx.mysqlclient.impl.codec.ResetStatementCommandCodec;
import io.vertx.mysqlclient.impl.codec.SetOptionCommandCodec;
import io.vertx.mysqlclient.impl.codec.SimpleQueryCommandCodec;
import io.vertx.mysqlclient.impl.codec.StatisticsCommandCodec;
import io.vertx.mysqlclient.impl.command.ChangeUserCommand;
import io.vertx.mysqlclient.impl.command.DebugCommand;
import io.vertx.mysqlclient.impl.command.InitDbCommand;
import io.vertx.mysqlclient.impl.command.InitialHandshakeCommand;
import io.vertx.mysqlclient.impl.command.PingCommand;
import io.vertx.mysqlclient.impl.command.ResetConnectionCommand;
import io.vertx.mysqlclient.impl.command.SetOptionCommand;
import io.vertx.mysqlclient.impl.command.StatisticsCommand;
import io.vertx.sqlclient.impl.command.CloseConnectionCommand;
import io.vertx.sqlclient.impl.command.CloseCursorCommand;
import io.vertx.sqlclient.impl.command.CloseStatementCommand;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.ExtendedBatchQueryCommand;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import java.nio.charset.Charset;
import java.util.ArrayDeque;

class MySQLEncoder
extends ChannelOutboundHandlerAdapter {
    private final ArrayDeque<CommandCodec<?, ?>> inflight;
    ChannelHandlerContext chctx;
    int clientCapabilitiesFlag;
    Charset encodingCharset;
    MySQLSocketConnection socketConnection;

    MySQLEncoder(ArrayDeque<CommandCodec<?, ?>> inflight, MySQLSocketConnection mySQLSocketConnection) {
        this.inflight = inflight;
        this.socketConnection = mySQLSocketConnection;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.chctx = ctx;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof CommandBase) {
            CommandBase cmd = (CommandBase)msg;
            this.write(cmd);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    void write(CommandBase<?> cmd) {
        CommandCodec<?, ?> codec = this.wrap(cmd);
        codec.completionHandler = resp -> {
            CommandCodec<?, ?> c = this.inflight.poll();
            resp.cmd = c.cmd;
            if (resp.cause() != null && resp.cause().getMessage().equals("SSL handshake failed")) {
                this.socketConnection.handleMessage(resp);
                return;
            }
            this.chctx.fireChannelRead(resp);
        };
        this.inflight.add(codec);
        codec.encode(this);
    }

    private CommandCodec<?, ?> wrap(CommandBase<?> cmd) {
        if (cmd instanceof InitialHandshakeCommand) {
            return new InitialHandshakeCommandCodec((InitialHandshakeCommand)cmd);
        }
        if (cmd instanceof SimpleQueryCommand) {
            return new SimpleQueryCommandCodec((SimpleQueryCommand)cmd);
        }
        if (cmd instanceof ExtendedQueryCommand) {
            return new ExtendedQueryCommandCodec((ExtendedQueryCommand)cmd);
        }
        if (cmd instanceof ExtendedBatchQueryCommand) {
            return new ExtendedBatchQueryCommandCodec((ExtendedBatchQueryCommand)cmd);
        }
        if (cmd instanceof CloseConnectionCommand) {
            return new CloseConnectionCommandCodec((CloseConnectionCommand)cmd);
        }
        if (cmd instanceof PrepareStatementCommand) {
            return new PrepareStatementCodec((PrepareStatementCommand)cmd);
        }
        if (cmd instanceof CloseStatementCommand) {
            return new CloseStatementCommandCodec((CloseStatementCommand)cmd);
        }
        if (cmd instanceof CloseCursorCommand) {
            return new ResetStatementCommandCodec((CloseCursorCommand)cmd);
        }
        if (cmd instanceof PingCommand) {
            return new PingCommandCodec((PingCommand)cmd);
        }
        if (cmd instanceof InitDbCommand) {
            return new InitDbCommandCodec((InitDbCommand)cmd);
        }
        if (cmd instanceof StatisticsCommand) {
            return new StatisticsCommandCodec((StatisticsCommand)cmd);
        }
        if (cmd instanceof SetOptionCommand) {
            return new SetOptionCommandCodec((SetOptionCommand)cmd);
        }
        if (cmd instanceof ResetConnectionCommand) {
            return new ResetConnectionCommandCodec((ResetConnectionCommand)cmd);
        }
        if (cmd instanceof DebugCommand) {
            return new DebugCommandCodec((DebugCommand)cmd);
        }
        if (cmd instanceof ChangeUserCommand) {
            return new ChangeUserCommandCodec((ChangeUserCommand)cmd);
        }
        System.out.println("Unsupported command " + cmd);
        throw new UnsupportedOperationException("Todo");
    }
}

