/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.spi;

import io.vertx.core.Vertx;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.spi.Driver;

public class MySQLDriver
implements Driver {
    public Pool createPool(SqlConnectOptions options, PoolOptions poolOptions) {
        return MySQLPool.pool(MySQLDriver.wrap(options), poolOptions);
    }

    public Pool createPool(Vertx vertx, SqlConnectOptions options, PoolOptions poolOptions) {
        return MySQLPool.pool(vertx, MySQLDriver.wrap(options), poolOptions);
    }

    public boolean acceptsOptions(SqlConnectOptions options) {
        return options instanceof MySQLConnectOptions || SqlConnectOptions.class.equals(options.getClass());
    }

    private static MySQLConnectOptions wrap(SqlConnectOptions options) {
        if (options instanceof MySQLConnectOptions) {
            return (MySQLConnectOptions)options;
        }
        return new MySQLConnectOptions(options);
    }
}

