/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.vertx.mysqlclient.impl.MySQLSocketConnection;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.InitialHandshakeCommandCodec;
import io.vertx.mysqlclient.impl.codec.MySQLDecoder;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import java.util.ArrayDeque;

public class MySQLCodec
extends CombinedChannelDuplexHandler<MySQLDecoder, MySQLEncoder> {
    ArrayDeque<CommandCodec<?, ?>> inflight = new ArrayDeque();

    public MySQLCodec(MySQLSocketConnection mySQLSocketConnection) {
        MySQLEncoder encoder = new MySQLEncoder(this.inflight, mySQLSocketConnection);
        MySQLDecoder decoder = new MySQLDecoder(this.inflight, mySQLSocketConnection);
        this.init((ChannelInboundHandler)decoder, (ChannelOutboundHandler)encoder);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.clearInflightCommands("Fail to read any response from the server, the underlying connection might get lost unexpectedly.");
        super.channelInactive(ctx);
    }

    private void clearInflightCommands(String failureMsg) {
        for (CommandCodec<?, ?> commandCodec : this.inflight) {
            if (commandCodec instanceof InitialHandshakeCommandCodec) continue;
            commandCodec.cmd.fail(failureMsg);
        }
    }
}

