/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.NetSocketInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.mysqlclient.MySQLAuthenticationPlugin;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.SslMode;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.mysqlclient.impl.MySQLSocketConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;

public class MySQLConnectionFactory {
    private final NetClient netClient;
    private final ContextInternal context;
    private final boolean registerCloseHook;
    private final SocketAddress socketAddress;
    private final String username;
    private final String password;
    private final String database;
    private final Map<String, String> connectionAttributes;
    private final MySQLCollation collation;
    private final Charset charsetEncoding;
    private final boolean useAffectedRows;
    private final SslMode sslMode;
    private final Buffer serverRsaPublicKey;
    private final boolean cachePreparedStatements;
    private final int preparedStatementCacheSize;
    private final Predicate<String> preparedStatementCacheSqlFilter;
    private final int initialCapabilitiesFlags;
    private final Closeable hook;
    private MySQLAuthenticationPlugin authenticationPlugin;

    public MySQLConnectionFactory(ContextInternal context, boolean registerCloseHook, MySQLConnectOptions options) {
        MySQLCollation collation;
        NetClientOptions netClientOptions = new NetClientOptions((NetClientOptions)options);
        this.context = context;
        this.registerCloseHook = registerCloseHook;
        this.hook = this::close;
        if (registerCloseHook) {
            context.addCloseHook(this.hook);
        }
        this.socketAddress = options.getSocketAddress();
        this.username = options.getUser();
        this.password = options.getPassword();
        this.database = options.getDatabase();
        Map<Object, Object> map = this.connectionAttributes = options.getProperties() == null ? null : Collections.unmodifiableMap(options.getProperties());
        if (options.getCollation() != null) {
            collation = MySQLCollation.valueOfName(options.getCollation());
            this.charsetEncoding = Charset.forName(collation.mappedJavaCharsetName());
        } else {
            String charset = options.getCharset();
            collation = charset == null ? MySQLCollation.DEFAULT_COLLATION : MySQLCollation.valueOfName(MySQLCollation.getDefaultCollationFromCharsetName(charset));
            String characterEncoding = options.getCharacterEncoding();
            this.charsetEncoding = characterEncoding == null ? Charset.defaultCharset() : Charset.forName(options.getCharacterEncoding());
        }
        this.collation = collation;
        this.useAffectedRows = options.isUseAffectedRows();
        this.sslMode = options.isUsingDomainSocket() ? SslMode.DISABLED : options.getSslMode();
        this.authenticationPlugin = options.getAuthenticationPlugin();
        Buffer serverRsaPublicKey = null;
        if (options.getServerRsaPublicKeyValue() != null) {
            serverRsaPublicKey = options.getServerRsaPublicKeyValue();
        } else if (options.getServerRsaPublicKeyPath() != null) {
            serverRsaPublicKey = context.owner().fileSystem().readFileBlocking(options.getServerRsaPublicKeyPath());
        }
        this.serverRsaPublicKey = serverRsaPublicKey;
        this.initialCapabilitiesFlags = this.initCapabilitiesFlags();
        switch (this.sslMode) {
            case VERIFY_IDENTITY: {
                String hostnameVerificationAlgorithm = netClientOptions.getHostnameVerificationAlgorithm();
                if (hostnameVerificationAlgorithm == null || hostnameVerificationAlgorithm.isEmpty()) {
                    throw new IllegalArgumentException("Host verification algorithm must be specified under VERIFY_IDENTITY ssl-mode.");
                }
            }
            case VERIFY_CA: {
                TrustOptions trustOptions = netClientOptions.getTrustOptions();
                if (trustOptions != null) break;
                throw new IllegalArgumentException("Trust options must be specified under " + this.sslMode.name() + " ssl-mode.");
            }
        }
        this.cachePreparedStatements = options.getCachePreparedStatements();
        this.preparedStatementCacheSize = options.getPreparedStatementCacheMaxSize();
        this.preparedStatementCacheSqlFilter = options.getPreparedStatementCacheSqlFilter();
        this.netClient = context.owner().createNetClient(netClientOptions);
    }

    private void close(Handler<AsyncResult<Void>> completionHandler) {
        this.netClient.close();
        completionHandler.handle((Object)Future.succeededFuture());
    }

    void close() {
        if (this.registerCloseHook) {
            this.context.removeCloseHook(this.hook);
        }
        this.netClient.close();
    }

    public void connect(Handler<AsyncResult<Connection>> handler) {
        Promise promise = Promise.promise();
        promise.future().setHandler(ar1 -> {
            if (ar1.succeeded()) {
                NetSocketInternal socket = (NetSocketInternal)ar1.result();
                MySQLSocketConnection conn = new MySQLSocketConnection(socket, this.cachePreparedStatements, this.preparedStatementCacheSize, this.preparedStatementCacheSqlFilter, (Context)this.context);
                conn.init();
                conn.sendStartupMessage(this.username, this.password, this.database, this.collation, this.serverRsaPublicKey, this.connectionAttributes, this.sslMode, this.initialCapabilitiesFlags, this.charsetEncoding, this.authenticationPlugin, (Handler<? super CommandResponse<Connection>>)handler);
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar1.cause()));
            }
        });
        this.netClient.connect(this.socketAddress, (Handler)promise);
    }

    private int initCapabilitiesFlags() {
        int capabilitiesFlags = 3121797;
        if (this.database != null && !this.database.isEmpty()) {
            capabilitiesFlags |= 8;
        }
        if (this.connectionAttributes != null && !this.connectionAttributes.isEmpty()) {
            capabilitiesFlags |= 0x100000;
        }
        if (!this.useAffectedRows) {
            capabilitiesFlags |= 2;
        }
        return capabilitiesFlags;
    }
}

