/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.sqlclient.spi.DatabaseMetadata;

public class MySQLDatabaseMetadata
implements DatabaseMetadata {
    private final String fullVersion;
    private final boolean isMariaDB;
    private final int majorVersion;
    private final int minorVersion;
    private final int microVersion;

    public MySQLDatabaseMetadata(String serverVersion) {
        String[] versionNumbers;
        this.fullVersion = serverVersion;
        this.isMariaDB = serverVersion.toUpperCase().contains("MARIADB");
        if (!this.isMariaDB) {
            versionNumbers = serverVersion.split("\\.");
        } else {
            String[] parts = serverVersion.split("-");
            versionNumbers = parts[1].split("\\.");
        }
        this.majorVersion = Integer.parseInt(versionNumbers[0]);
        this.minorVersion = Integer.parseInt(versionNumbers[1]);
        String releaseVersion = versionNumbers[2];
        int indexOfFirstSeparator = releaseVersion.indexOf("-");
        if (indexOfFirstSeparator != -1) {
            String releaseNumberString = releaseVersion.substring(0, indexOfFirstSeparator);
            this.microVersion = Integer.parseInt(releaseNumberString);
        } else {
            this.microVersion = Integer.parseInt(versionNumbers[2]);
        }
    }

    public boolean isMariaDB() {
        return this.isMariaDB;
    }

    public String productName() {
        return this.isMariaDB ? "MariaDB" : "MySQL";
    }

    public String fullVersion() {
        return this.fullVersion;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }

    public int getDatabasMicroVersion() {
        return this.microVersion;
    }
}

