/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.mysqlclient.impl.MySQLRowDesc;
import io.vertx.mysqlclient.impl.datatype.DataType;
import io.vertx.mysqlclient.impl.protocol.ColumnDefinition;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.ArrayTuple;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.UUID;

public class MySQLRowImpl
extends ArrayTuple
implements Row {
    private final MySQLRowDesc rowDesc;

    public MySQLRowImpl(MySQLRowDesc rowDesc) {
        super(rowDesc.columnNames().size());
        this.rowDesc = rowDesc;
    }

    public <T> T get(Class<T> type, int pos) {
        if (type == Boolean.class) {
            return type.cast(this.getBoolean(pos));
        }
        if (type == Byte.class) {
            return type.cast(this.getByte(pos));
        }
        if (type == Short.class) {
            return type.cast(this.getShort(pos));
        }
        if (type == Integer.class) {
            return type.cast(this.getInteger(pos));
        }
        if (type == Long.class) {
            return type.cast(this.getLong(pos));
        }
        if (type == Float.class) {
            return type.cast(this.getFloat(pos));
        }
        if (type == Double.class) {
            return type.cast(this.getDouble(pos));
        }
        if (type == Numeric.class) {
            return type.cast(this.getNumeric(pos));
        }
        if (type == String.class) {
            return type.cast(this.getString(pos));
        }
        if (type == Buffer.class) {
            return type.cast(this.getBuffer(pos));
        }
        if (type == LocalDate.class) {
            return type.cast(this.getLocalDate(pos));
        }
        if (type == LocalDateTime.class) {
            return type.cast(this.getLocalDateTime(pos));
        }
        if (type == Duration.class) {
            return type.cast(this.getDuration(pos));
        }
        if (type == JsonObject.class) {
            return type.cast(this.getJsonObject(pos));
        }
        if (type == JsonArray.class) {
            return type.cast(this.getJsonArray(pos));
        }
        throw new UnsupportedOperationException("Unsupported type " + type.getName());
    }

    public <T> T[] getValues(Class<T> type, int idx) {
        throw new UnsupportedOperationException("MySQL Array data type is not supported");
    }

    public String getColumnName(int pos) {
        List columnNames = this.rowDesc.columnNames();
        return pos < 0 || columnNames.size() - 1 < pos ? null : (String)columnNames.get(pos);
    }

    public int getColumnIndex(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.rowDesc.columnNames().indexOf(name);
    }

    public Numeric getNumeric(String column) {
        int pos = this.rowDesc.columnIndex(column);
        return pos == -1 ? null : this.getNumeric(pos);
    }

    public Temporal getTemporal(String column) {
        throw new UnsupportedOperationException();
    }

    public LocalTime getLocalTime(String column) {
        int pos = this.getColumnIndex(column);
        return pos == -1 ? null : this.getLocalTime(pos);
    }

    public OffsetTime getOffsetTime(String column) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(column), column, OffsetTime.class));
    }

    public OffsetDateTime getOffsetDateTime(String column) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(column), column, OffsetDateTime.class));
    }

    public UUID getUUID(String column) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(column), column, UUID.class));
    }

    public Integer[] getIntegerArray(String column) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(column), column, Integer[].class));
    }

    public Boolean[] getBooleanArray(String column) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(column), column, Boolean[].class));
    }

    public Short[] getShortArray(String column) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(column), column, Short[].class));
    }

    public Long[] getLongArray(String column) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(column), column, Long[].class));
    }

    public Float[] getFloatArray(String column) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(column), column, Float[].class));
    }

    public Double[] getDoubleArray(String column) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(column), column, Double[].class));
    }

    public String[] getStringArray(String column) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(column), column, String[].class));
    }

    public LocalDate[] getLocalDateArray(String column) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(column), column, LocalDate[].class));
    }

    public LocalTime[] getLocalTimeArray(String column) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(column), column, LocalTime[].class));
    }

    public OffsetTime[] getOffsetTimeArray(String column) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(column), column, OffsetTime[].class));
    }

    public LocalDateTime[] getArrayOfLocalDateTimes(int pos) {
        throw new UnsupportedOperationException();
    }

    public LocalDateTime[] getLocalDateTimeArray(String column) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(column), column, LocalDateTime[].class));
    }

    public OffsetDateTime[] getArrayOfOffsetDateTimes(int pos) {
        throw new UnsupportedOperationException();
    }

    public OffsetDateTime[] getOffsetDateTimeArray(String column) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(column), column, OffsetDateTime[].class));
    }

    public Buffer[] getArrayOfBuffers(String column) {
        throw new UnsupportedOperationException();
    }

    public Buffer[] getBufferArray(String column) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(column), column, Buffer[].class));
    }

    public UUID[] getArrayOfUUIDs(String column) {
        throw new UnsupportedOperationException();
    }

    public UUID[] getUUIDArray(String column) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(column), column, UUID[].class));
    }

    public Boolean getBoolean(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue() != 0;
        }
        return null;
    }

    private Byte getByte(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Byte) {
            return (Byte)val;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        return null;
    }

    private Duration getDuration(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Duration) {
            return (Duration)val;
        }
        return null;
    }

    private JsonObject getJsonObject(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof JsonObject) {
            return (JsonObject)val;
        }
        return null;
    }

    private JsonArray getJsonArray(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof JsonArray) {
            return (JsonArray)val;
        }
        return null;
    }

    public LocalTime getLocalTime(int pos) {
        ColumnDefinition columnDefinition = this.rowDesc.columnDefinitions()[pos];
        Object val = this.getValue(pos);
        if (columnDefinition.type() == DataType.TIME && val instanceof Duration) {
            Duration duration = (Duration)val;
            return LocalTime.ofNanoOfDay(duration.toNanos());
        }
        return super.getLocalTime(pos);
    }

    private <T> String buildIllegalAccessMessage(Object value, String columnName, Class<T> clazz) {
        return String.format("Can not retrieve row value[%s] as class[%s], columnName=[%s]", value.toString(), clazz.getName(), columnName);
    }
}

