/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.datatype;

import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.sqlclient.data.Numeric;
import java.sql.JDBCType;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;

public enum DataType {
    INT1(1, Byte.class, Byte.class, JDBCType.TINYINT),
    INT2(2, Short.class, Short.class, JDBCType.SMALLINT),
    INT3(9, Integer.class, Integer.class, JDBCType.INTEGER),
    INT4(3, Integer.class, Integer.class, JDBCType.INTEGER),
    INT8(8, Long.class, Long.class, JDBCType.BIGINT),
    DOUBLE(5, Double.class, Double.class, JDBCType.DOUBLE),
    FLOAT(4, Float.class, Float.class, JDBCType.REAL),
    NUMERIC(246, Numeric.class, Numeric.class, JDBCType.DECIMAL),
    STRING(254, Buffer.class, String.class, JDBCType.VARCHAR),
    VARSTRING(253, Buffer.class, String.class, JDBCType.VARCHAR),
    TINYBLOB(249, Buffer.class, String.class, JDBCType.BLOB),
    BLOB(252, Buffer.class, String.class, JDBCType.BLOB),
    MEDIUMBLOB(250, Buffer.class, String.class, JDBCType.BLOB),
    LONGBLOB(251, Buffer.class, String.class, JDBCType.BLOB),
    DATE(10, LocalDate.class, LocalDate.class, JDBCType.DATE),
    TIME(11, Duration.class, Duration.class, JDBCType.TIME),
    DATETIME(12, LocalDateTime.class, LocalDateTime.class, JDBCType.TIMESTAMP),
    YEAR(13, Short.class, Short.class, JDBCType.SMALLINT),
    TIMESTAMP(7, LocalDateTime.class, LocalDateTime.class, JDBCType.TIMESTAMP),
    BIT(16, Long.class, Long.class, JDBCType.BIT),
    JSON(245, Object.class, Object.class, JDBCType.OTHER),
    NULL(6, Object.class, Object.class, JDBCType.OTHER),
    UNBIND(-1, Object.class, Object.class, JDBCType.OTHER);

    private static final Logger LOGGER;
    private static IntObjectMap<DataType> idToDataType;
    public final int id;
    public final Class<?> binaryType;
    public final Class<?> textType;
    public final JDBCType jdbcType;

    private DataType(int id, Class<?> binaryType, Class<?> textType, JDBCType jdbcType) {
        this.id = id;
        this.binaryType = binaryType;
        this.textType = textType;
        this.jdbcType = jdbcType;
    }

    public static DataType valueOf(int value) {
        DataType dataType = (DataType)((Object)idToDataType.get(value));
        if (dataType == null) {
            LOGGER.warn((Object)String.format("MySQL data type Id =[%d] not handled - using string type instead", value));
            return STRING;
        }
        return dataType;
    }

    static {
        LOGGER = LoggerFactory.getLogger(DataType.class);
        idToDataType = new IntObjectHashMap();
        for (DataType dataType : DataType.values()) {
            idToDataType.put(dataType.id, (Object)dataType);
        }
    }
}

