/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.mysqlclient.MySQLAuthenticationPlugin;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.SslMode;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.mysqlclient.impl.MySQLSocketConnection;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import io.vertx.sqlclient.impl.SqlConnectionFactoryBase;
import java.nio.charset.Charset;

public class MySQLConnectionFactory
extends SqlConnectionFactoryBase
implements ConnectionFactory {
    private MySQLCollation collation;
    private Charset charsetEncoding;
    private boolean useAffectedRows;
    private SslMode sslMode;
    private Buffer serverRsaPublicKey;
    private int initialCapabilitiesFlags;
    private MySQLAuthenticationPlugin authenticationPlugin;

    public MySQLConnectionFactory(VertxInternal vertx, MySQLConnectOptions options) {
        super(vertx, (SqlConnectOptions)options);
    }

    protected void initializeConfiguration(SqlConnectOptions connectOptions) {
        MySQLCollation collation;
        if (!(connectOptions instanceof MySQLConnectOptions)) {
            throw new IllegalArgumentException("mismatched connect options type");
        }
        MySQLConnectOptions options = (MySQLConnectOptions)connectOptions;
        if (options.getCollation() != null) {
            collation = MySQLCollation.valueOfName(options.getCollation());
            this.charsetEncoding = Charset.forName(collation.mappedJavaCharsetName());
        } else {
            String charset = options.getCharset();
            collation = charset == null ? MySQLCollation.DEFAULT_COLLATION : MySQLCollation.valueOfName(MySQLCollation.getDefaultCollationFromCharsetName(charset));
            String characterEncoding = options.getCharacterEncoding();
            this.charsetEncoding = characterEncoding == null ? Charset.defaultCharset() : Charset.forName(options.getCharacterEncoding());
        }
        this.collation = collation;
        this.useAffectedRows = options.isUseAffectedRows();
        this.sslMode = options.isUsingDomainSocket() ? SslMode.DISABLED : options.getSslMode();
        this.authenticationPlugin = options.getAuthenticationPlugin();
        Buffer serverRsaPublicKey = null;
        if (options.getServerRsaPublicKeyValue() != null) {
            serverRsaPublicKey = options.getServerRsaPublicKeyValue();
        } else if (options.getServerRsaPublicKeyPath() != null) {
            serverRsaPublicKey = this.vertx.fileSystem().readFileBlocking(options.getServerRsaPublicKeyPath());
        }
        this.serverRsaPublicKey = serverRsaPublicKey;
        this.initialCapabilitiesFlags = this.initCapabilitiesFlags();
        switch (this.sslMode) {
            case VERIFY_IDENTITY: {
                String hostnameVerificationAlgorithm = options.getHostnameVerificationAlgorithm();
                if (hostnameVerificationAlgorithm == null || hostnameVerificationAlgorithm.isEmpty()) {
                    throw new IllegalArgumentException("Host verification algorithm must be specified under VERIFY_IDENTITY ssl-mode.");
                }
            }
            case VERIFY_CA: {
                TrustOptions trustOptions = options.getTrustOptions();
                if (trustOptions != null) break;
                throw new IllegalArgumentException("Trust options must be specified under " + this.sslMode.name() + " ssl-mode.");
            }
        }
    }

    protected void configureNetClientOptions(NetClientOptions netClientOptions) {
        netClientOptions.setSsl(false);
    }

    protected void doConnectInternal(Promise<Connection> promise) {
        PromiseInternal promiseInternal = (PromiseInternal)promise;
        EventLoopContext context = ConnectionFactory.asEventLoopContext((ContextInternal)promiseInternal.context());
        Future fut = this.netClient.connect(this.socketAddress);
        fut.onComplete(ar -> {
            if (ar.succeeded()) {
                NetSocket so = (NetSocket)ar.result();
                MySQLSocketConnection conn = new MySQLSocketConnection((NetSocketInternal)so, this.cachePreparedStatements, this.preparedStatementCacheSize, this.preparedStatementCacheSqlFilter, context);
                conn.init();
                conn.sendStartupMessage(this.username, this.password, this.database, this.collation, this.serverRsaPublicKey, this.properties, this.sslMode, this.initialCapabilitiesFlags, this.charsetEncoding, this.authenticationPlugin, promise);
            } else {
                promise.fail(ar.cause());
            }
        });
    }

    private int initCapabilitiesFlags() {
        int capabilitiesFlags = 3121797;
        if (this.database != null && !this.database.isEmpty()) {
            capabilitiesFlags |= 8;
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            capabilitiesFlags |= 0x100000;
        }
        if (!this.useAffectedRows) {
            capabilitiesFlags |= 2;
        }
        return capabilitiesFlags;
    }
}

