/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.mysqlclient.data.spatial.Geometry;
import io.vertx.mysqlclient.data.spatial.GeometryCollection;
import io.vertx.mysqlclient.data.spatial.LineString;
import io.vertx.mysqlclient.data.spatial.MultiLineString;
import io.vertx.mysqlclient.data.spatial.MultiPoint;
import io.vertx.mysqlclient.data.spatial.MultiPolygon;
import io.vertx.mysqlclient.data.spatial.Point;
import io.vertx.mysqlclient.data.spatial.Polygon;
import io.vertx.mysqlclient.impl.MySQLRowDesc;
import io.vertx.mysqlclient.impl.datatype.DataType;
import io.vertx.mysqlclient.impl.protocol.ColumnDefinition;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.ArrayTuple;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.UUID;

public class MySQLRowImpl
extends ArrayTuple
implements Row {
    private final MySQLRowDesc rowDesc;

    public MySQLRowImpl(MySQLRowDesc rowDesc) {
        super(rowDesc.columnNames().size());
        this.rowDesc = rowDesc;
    }

    public <T> T get(Class<T> type, int position) {
        if (type == Boolean.class) {
            return type.cast(this.getBoolean(position));
        }
        if (type == Byte.class) {
            return type.cast(this.getByte(position));
        }
        if (type == Short.class) {
            return type.cast(this.getShort(position));
        }
        if (type == Integer.class) {
            return type.cast(this.getInteger(position));
        }
        if (type == Long.class) {
            return type.cast(this.getLong(position));
        }
        if (type == Float.class) {
            return type.cast(this.getFloat(position));
        }
        if (type == Double.class) {
            return type.cast(this.getDouble(position));
        }
        if (type == Numeric.class) {
            return type.cast(this.getNumeric(position));
        }
        if (type == String.class) {
            return type.cast(this.getString(position));
        }
        if (type == Buffer.class) {
            return type.cast(this.getBuffer(position));
        }
        if (type == LocalDate.class) {
            return type.cast(this.getLocalDate(position));
        }
        if (type == LocalDateTime.class) {
            return type.cast(this.getLocalDateTime(position));
        }
        if (type == Duration.class) {
            return type.cast(this.getDuration(position));
        }
        if (type == JsonObject.class) {
            return type.cast(this.getJsonObject(position));
        }
        if (type == JsonArray.class) {
            return type.cast(this.getJsonArray(position));
        }
        if (type == Geometry.class) {
            return type.cast(this.getGeometry(position));
        }
        if (type == Point.class) {
            return type.cast(this.getPoint(position));
        }
        if (type == LineString.class) {
            return type.cast(this.getLineString(position));
        }
        if (type == Polygon.class) {
            return type.cast(this.getPolygon(position));
        }
        if (type == MultiPoint.class) {
            return type.cast(this.getMultiPoint(position));
        }
        if (type == MultiLineString.class) {
            return type.cast(this.getMultiLineString(position));
        }
        if (type == MultiPolygon.class) {
            return type.cast(this.getMultiPolygon(position));
        }
        if (type == GeometryCollection.class) {
            return type.cast(this.getGeometryCollection(position));
        }
        if (type.isEnum()) {
            return type.cast(this.getEnum(type, position));
        }
        throw new UnsupportedOperationException("Unsupported type " + type.getName());
    }

    public String getColumnName(int pos) {
        List columnNames = this.rowDesc.columnNames();
        return pos < 0 || columnNames.size() - 1 < pos ? null : (String)columnNames.get(pos);
    }

    public int getColumnIndex(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.rowDesc.columnNames().indexOf(name);
    }

    public Temporal getTemporal(int pos) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(pos), this.getColumnName(pos), Temporal.class));
    }

    public OffsetTime getOffsetTime(int pos) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(pos), this.getColumnName(pos), OffsetTime.class));
    }

    public OffsetDateTime getOffsetDateTime(int pos) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(pos), this.getColumnName(pos), OffsetDateTime.class));
    }

    public UUID getUUID(int pos) {
        throw new UnsupportedOperationException(this.buildIllegalAccessMessage(this.getValue(pos), this.getColumnName(pos), UUID.class));
    }

    public LocalDateTime[] getArrayOfLocalDateTimes(int pos) {
        throw new UnsupportedOperationException();
    }

    public OffsetDateTime[] getArrayOfOffsetDateTimes(int pos) {
        throw new UnsupportedOperationException();
    }

    public Buffer[] getArrayOfBuffers(String column) {
        throw new UnsupportedOperationException();
    }

    public UUID[] getArrayOfUUIDs(String column) {
        throw new UnsupportedOperationException();
    }

    public Boolean getBoolean(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue() != 0;
        }
        return null;
    }

    private Byte getByte(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Byte) {
            return (Byte)val;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        return null;
    }

    private Duration getDuration(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Duration) {
            return (Duration)val;
        }
        return null;
    }

    private Geometry getGeometry(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Geometry) {
            return (Geometry)val;
        }
        return null;
    }

    private Point getPoint(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Point) {
            return (Point)val;
        }
        return null;
    }

    private LineString getLineString(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof LineString) {
            return (LineString)val;
        }
        return null;
    }

    private Polygon getPolygon(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Polygon) {
            return (Polygon)val;
        }
        return null;
    }

    private MultiPoint getMultiPoint(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof MultiPoint) {
            return (MultiPoint)val;
        }
        return null;
    }

    private MultiLineString getMultiLineString(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof MultiLineString) {
            return (MultiLineString)val;
        }
        return null;
    }

    private MultiPolygon getMultiPolygon(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof MultiPolygon) {
            return (MultiPolygon)val;
        }
        return null;
    }

    private GeometryCollection getGeometryCollection(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof GeometryCollection) {
            return (GeometryCollection)val;
        }
        return null;
    }

    public LocalTime getLocalTime(int pos) {
        ColumnDefinition columnDefinition = this.rowDesc.get(pos);
        Object val = this.getValue(pos);
        if (columnDefinition.type() == DataType.TIME && val instanceof Duration) {
            Duration duration = (Duration)val;
            return LocalTime.ofNanoOfDay(duration.toNanos());
        }
        return super.getLocalTime(pos);
    }

    private Object getEnum(Class enumType, int position) {
        Object val = this.getValue(position);
        if (val instanceof String) {
            return Enum.valueOf(enumType, (String)val);
        }
        if (val instanceof Number) {
            T[] constants;
            int ordinal = ((Number)val).intValue();
            if (ordinal >= 0 && ordinal < (constants = enumType.getEnumConstants()).length) {
                return constants[ordinal];
            }
        } else if (val == null) {
            return null;
        }
        throw new ClassCastException();
    }

    private <T> String buildIllegalAccessMessage(Object value, String columnName, Class<T> clazz) {
        return String.format("Can not retrieve row value[%s] as class[%s], columnName=[%s]", value.toString(), clazz.getName(), columnName);
    }
}

