/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.mysqlclient.MySQLAuthenticationPlugin;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.SslMode;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.mysqlclient.impl.MySQLConnectionImpl;
import io.vertx.mysqlclient.impl.MySQLSocketConnection;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactoryBase;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.nio.charset.Charset;

public class MySQLConnectionFactory
extends ConnectionFactoryBase {
    private MySQLCollation collation;
    private Charset charsetEncoding;
    private boolean useAffectedRows;
    private SslMode sslMode;
    private Buffer serverRsaPublicKey;
    private int initialCapabilitiesFlags;
    private int pipeliningLimit;
    private MySQLAuthenticationPlugin authenticationPlugin;

    public MySQLConnectionFactory(VertxInternal vertx, MySQLConnectOptions options) {
        super(vertx, (SqlConnectOptions)options);
    }

    protected void initializeConfiguration(SqlConnectOptions connectOptions) {
        MySQLCollation collation;
        if (!(connectOptions instanceof MySQLConnectOptions)) {
            throw new IllegalArgumentException("mismatched connect options type");
        }
        MySQLConnectOptions options = (MySQLConnectOptions)connectOptions;
        if (options.getCollation() != null) {
            collation = MySQLCollation.valueOfName(options.getCollation());
            this.charsetEncoding = Charset.forName(collation.mappedJavaCharsetName());
        } else {
            String charset = options.getCharset();
            collation = charset == null ? MySQLCollation.DEFAULT_COLLATION : MySQLCollation.valueOfName(MySQLCollation.getDefaultCollationFromCharsetName(charset));
            String characterEncoding = options.getCharacterEncoding();
            this.charsetEncoding = characterEncoding == null ? Charset.defaultCharset() : Charset.forName(options.getCharacterEncoding());
        }
        this.collation = collation;
        this.useAffectedRows = options.isUseAffectedRows();
        this.sslMode = options.isUsingDomainSocket() ? SslMode.DISABLED : options.getSslMode();
        this.authenticationPlugin = options.getAuthenticationPlugin();
        Buffer serverRsaPublicKey = null;
        if (options.getServerRsaPublicKeyValue() != null) {
            serverRsaPublicKey = options.getServerRsaPublicKeyValue();
        } else if (options.getServerRsaPublicKeyPath() != null) {
            serverRsaPublicKey = this.vertx.fileSystem().readFileBlocking(options.getServerRsaPublicKeyPath());
        }
        this.serverRsaPublicKey = serverRsaPublicKey;
        this.initialCapabilitiesFlags = this.initCapabilitiesFlags(this.database);
        this.pipeliningLimit = options.getPipeliningLimit();
        switch (this.sslMode) {
            case VERIFY_IDENTITY: {
                String hostnameVerificationAlgorithm = options.getHostnameVerificationAlgorithm();
                if (hostnameVerificationAlgorithm == null || hostnameVerificationAlgorithm.isEmpty()) {
                    throw new IllegalArgumentException("Host verification algorithm must be specified under VERIFY_IDENTITY ssl-mode.");
                }
            }
            case VERIFY_CA: {
                TrustOptions trustOptions = options.getTrustOptions();
                if (trustOptions != null) break;
                throw new IllegalArgumentException("Trust options must be specified under " + this.sslMode.name() + " ssl-mode.");
            }
        }
    }

    protected void configureNetClientOptions(NetClientOptions netClientOptions) {
        netClientOptions.setSsl(false);
    }

    protected Future<Connection> doConnectInternal(SocketAddress server, String username, String password, String database, EventLoopContext context) {
        if (this.sslMode == SslMode.PREFERRED) {
            return this.doConnect(server, username, password, database, this.sslMode, context).recover(err -> this.doConnect(server, username, password, database, SslMode.DISABLED, context));
        }
        return this.doConnect(server, username, password, database, this.sslMode, context);
    }

    private Future<Connection> doConnect(SocketAddress server, String username, String password, String database, SslMode sslMode, EventLoopContext context) {
        Future fut = this.netClient.connect(server);
        return fut.flatMap(so -> {
            MySQLSocketConnection conn = new MySQLSocketConnection((NetSocketInternal)so, this.cachePreparedStatements, this.preparedStatementCacheSize, this.preparedStatementCacheSqlFilter, this.pipeliningLimit, context);
            conn.init();
            return Future.future(promise -> conn.sendStartupMessage(username, password, database, this.collation, this.serverRsaPublicKey, this.properties, sslMode, this.initialCapabilitiesFlags, this.charsetEncoding, this.authenticationPlugin, (Promise<Connection>)promise));
        });
    }

    private int initCapabilitiesFlags(String database) {
        int capabilitiesFlags = 3121797;
        if (database != null && !database.isEmpty()) {
            capabilitiesFlags |= 8;
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            capabilitiesFlags |= 0x100000;
        }
        if (!this.useAffectedRows) {
            capabilitiesFlags |= 2;
        }
        return capabilitiesFlags;
    }

    public Future<SqlConnection> connect(Context context) {
        ContextInternal contextInternal = (ContextInternal)context;
        QueryTracer tracer = contextInternal.tracer() == null ? null : new QueryTracer(contextInternal.tracer(), this.options);
        PromiseInternal promise = contextInternal.promise();
        this.connect(MySQLConnectionFactory.asEventLoopContext((ContextInternal)contextInternal)).map(conn -> {
            MySQLConnectionImpl mySQLConnection = new MySQLConnectionImpl(contextInternal, (ConnectionFactory)this, (Connection)conn, tracer, null);
            conn.init((Connection.Holder)mySQLConnection);
            return mySQLConnection;
        }).onComplete((Handler)promise);
        return promise.future();
    }
}

