/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.mysqlclient.MySQLBatchException;
import io.vertx.mysqlclient.MySQLException;
import io.vertx.mysqlclient.impl.codec.ExtendedQueryCommandBaseCodec;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.codec.QueryCommandBaseCodec;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.TupleInternal;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.util.BitSet;
import java.util.List;

class ExtendedBatchQueryCommandCodec<R>
extends ExtendedQueryCommandBaseCodec<R, ExtendedQueryCommand<R>> {
    private final List<TupleInternal> params;
    private final BitSet bindingFailures;
    private boolean pipeliningEnabled;
    private int sent;
    private int received;

    ExtendedBatchQueryCommandCodec(ExtendedQueryCommand<R> cmd) {
        super(cmd);
        this.params = cmd.paramsList();
        this.bindingFailures = new BitSet(this.params.size());
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        if (this.params.isEmpty() && this.statement.paramDesc.paramDefinitions().length > 0) {
            encoder.handleCommandResponse(CommandResponse.failure((String)"Statement parameter is not set because of the empty batch param list"));
            return;
        }
        this.pipeliningEnabled = encoder.socketConnection.pipeliningEnabled();
        encoder.socketConnection.suspendPipeline();
        this.doExecuteBatch();
    }

    @Override
    void handleErrorPacketPayload(ByteBuf payload) {
        this.skipBindingFailures();
        MySQLException mySQLException = this.decodeErrorPacketPayload(payload);
        this.reportError(this.received++, mySQLException);
        this.commandHandlerState = QueryCommandBaseCodec.CommandHandlerState.INIT;
        if (this.received == this.params.size()) {
            super.closePreparedStatement();
            this.encoder.socketConnection.resumePipeline();
            this.encoder.handleCommandResponse(CommandResponse.failure((Throwable)this.failure));
        } else {
            this.doExecuteBatch();
        }
    }

    private void skipBindingFailures() {
        this.received = this.bindingFailures.nextClearBit(this.received);
    }

    @Override
    protected void handleSingleResultsetDecodingCompleted(int serverStatusFlags, int affectedRows, long lastInsertId) {
        this.skipBindingFailures();
        ++this.received;
        super.handleSingleResultsetDecodingCompleted(serverStatusFlags, affectedRows, lastInsertId);
        this.doExecuteBatch();
    }

    @Override
    protected boolean isDecodingCompleted(int serverStatusFlags) {
        return super.isDecodingCompleted(serverStatusFlags) && this.received == this.params.size();
    }

    @Override
    protected void handleAllResultsetDecodingCompleted() {
        this.encoder.socketConnection.resumePipeline();
        super.closePreparedStatement();
        super.handleAllResultsetDecodingCompleted();
    }

    @Override
    protected void closePreparedStatement() {
    }

    private void doExecuteBatch() {
        while (this.sent < this.params.size()) {
            Tuple param = (Tuple)this.params.get(this.sent);
            this.sequenceId = 0;
            String bindMsg = this.statement.bindParameters(param);
            if (bindMsg != null) {
                this.bindingFailures.set(this.sent);
                this.reportError(this.sent, (Throwable)new NoStackTraceThrowable(bindMsg));
                ++this.sent;
                continue;
            }
            this.sendStatementExecuteCommand(this.statement, this.statement.sendTypesToServer(), param, (byte)0);
            ++this.sent;
            if (this.pipeliningEnabled) continue;
            break;
        }
    }

    private void reportError(int iteration, Throwable error) {
        MySQLBatchException batchException = (MySQLBatchException)this.failure;
        if (batchException == null) {
            batchException = new MySQLBatchException();
            this.failure = batchException;
        }
        batchException.reportError(iteration, error);
    }
}

