/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.mysqlclient.MySQLAuthenticationPlugin;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.SslMode;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.mysqlclient.impl.MySQLConnectionImpl;
import io.vertx.mysqlclient.impl.MySQLSocketConnection;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactoryBase;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class MySQLConnectionFactory
extends ConnectionFactoryBase {
    public MySQLConnectionFactory(VertxInternal vertx, Supplier<? extends Future<? extends SqlConnectOptions>> options) {
        super(vertx, options);
    }

    protected Future<Connection> doConnectInternal(SqlConnectOptions options, EventLoopContext context) {
        MySQLConnectOptions mySQLOptions = MySQLConnectOptions.wrap(options);
        SslMode sslMode = mySQLOptions.isUsingDomainSocket() ? SslMode.DISABLED : mySQLOptions.getSslMode();
        switch (sslMode) {
            case VERIFY_IDENTITY: {
                String hostnameVerificationAlgorithm = options.getHostnameVerificationAlgorithm();
                if (hostnameVerificationAlgorithm != null && !hostnameVerificationAlgorithm.isEmpty()) break;
                return context.failedFuture((Throwable)new IllegalArgumentException("Host verification algorithm must be specified under VERIFY_IDENTITY ssl-mode."));
            }
            case VERIFY_CA: {
                TrustOptions trustOptions = options.getTrustOptions();
                if (trustOptions != null) break;
                return context.failedFuture((Throwable)new IllegalArgumentException("Trust options must be specified under " + sslMode.name() + " ssl-mode."));
            }
        }
        int capabilitiesFlag = this.capabilitiesFlags(mySQLOptions);
        options.setSsl(false);
        if (sslMode == SslMode.PREFERRED) {
            return this.doConnect(mySQLOptions, sslMode, capabilitiesFlag, context).recover(err -> this.doConnect(mySQLOptions, SslMode.DISABLED, capabilitiesFlag, context));
        }
        return this.doConnect(mySQLOptions, sslMode, capabilitiesFlag, context);
    }

    private int capabilitiesFlags(MySQLConnectOptions options) {
        int capabilitiesFlags = 3121797;
        if (options.getDatabase() != null && !options.getDatabase().isEmpty()) {
            capabilitiesFlags |= 8;
        }
        if (options.getProperties() != null && !options.getProperties().isEmpty()) {
            capabilitiesFlags |= 0x100000;
        }
        if (!options.isUseAffectedRows()) {
            capabilitiesFlags |= 2;
        }
        return capabilitiesFlags;
    }

    private Future<Connection> doConnect(MySQLConnectOptions options, SslMode sslMode, int initialCapabilitiesFlags, EventLoopContext context) {
        Charset charsetEncoding;
        MySQLCollation collation;
        String username = options.getUser();
        String password = options.getPassword();
        String database = options.getDatabase();
        SocketAddress server = options.getSocketAddress();
        boolean cachePreparedStatements = options.getCachePreparedStatements();
        int preparedStatementCacheMaxSize = options.getPreparedStatementCacheMaxSize();
        Predicate preparedStatementCacheSqlFilter = options.getPreparedStatementCacheSqlFilter();
        Map properties = options.getProperties();
        if (options.getCollation() != null) {
            collation = MySQLCollation.valueOfName(options.getCollation());
            charsetEncoding = Charset.forName(collation.mappedJavaCharsetName());
        } else {
            String charset = options.getCharset();
            collation = charset == null ? MySQLCollation.DEFAULT_COLLATION : MySQLCollation.valueOfName(MySQLCollation.getDefaultCollationFromCharsetName(charset));
            String characterEncoding = options.getCharacterEncoding();
            charsetEncoding = characterEncoding == null ? Charset.defaultCharset() : Charset.forName(options.getCharacterEncoding());
        }
        Object serverRsaPublicKey = options.getServerRsaPublicKeyValue() != null ? options.getServerRsaPublicKeyValue() : (options.getServerRsaPublicKeyPath() != null ? this.vertx.fileSystem().readFileBlocking(options.getServerRsaPublicKeyPath()) : null);
        int pipeliningLimit = options.getPipeliningLimit();
        MySQLAuthenticationPlugin authenticationPlugin = options.getAuthenticationPlugin();
        Future fut = this.netClient((NetClientOptions)options).connect(server);
        return fut.flatMap(arg_0 -> this.lambda$doConnect$2(options, cachePreparedStatements, preparedStatementCacheMaxSize, preparedStatementCacheSqlFilter, pipeliningLimit, context, username, password, database, collation, (Buffer)serverRsaPublicKey, properties, sslMode, initialCapabilitiesFlags, charsetEncoding, authenticationPlugin, arg_0));
    }

    public Future<SqlConnection> connect(Context context, SqlConnectOptions options) {
        ContextInternal contextInternal = (ContextInternal)context;
        PromiseInternal promise = contextInternal.promise();
        this.connect(MySQLConnectionFactory.asEventLoopContext((ContextInternal)contextInternal), options).map(conn -> {
            MySQLConnectionImpl mySQLConnection = new MySQLConnectionImpl(contextInternal, (ConnectionFactory)this, (Connection)conn);
            conn.init((Connection.Holder)mySQLConnection);
            return mySQLConnection;
        }).onComplete((Handler)promise);
        return promise.future();
    }

    private /* synthetic */ Future lambda$doConnect$2(MySQLConnectOptions options, boolean cachePreparedStatements, int preparedStatementCacheMaxSize, Predicate preparedStatementCacheSqlFilter, int pipeliningLimit, EventLoopContext context, String username, String password, String database, MySQLCollation collation, Buffer serverRsaPublicKey, Map properties, SslMode sslMode, int initialCapabilitiesFlags, Charset charsetEncoding, MySQLAuthenticationPlugin authenticationPlugin, NetSocket so) {
        VertxMetrics vertxMetrics = this.vertx.metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(options.getSocketAddress(), "sql", options.getMetricsName()) : null;
        MySQLSocketConnection conn = new MySQLSocketConnection((NetSocketInternal)so, metrics, options, cachePreparedStatements, preparedStatementCacheMaxSize, preparedStatementCacheSqlFilter, pipeliningLimit, context);
        conn.init();
        return Future.future(promise -> conn.sendStartupMessage(username, password, database, collation, serverRsaPublicKey, properties, sslMode, initialCapabilitiesFlags, charsetEncoding, authenticationPlugin, (Promise<Connection>)promise));
    }
}

