/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.vertx.mysqlclient.impl.MySQLParamDesc;
import io.vertx.mysqlclient.impl.MySQLRowDesc;
import io.vertx.mysqlclient.impl.datatype.DataType;
import io.vertx.mysqlclient.impl.datatype.DataTypeCodec;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.ErrorMessageFactory;
import io.vertx.sqlclient.internal.ParamDesc;
import io.vertx.sqlclient.internal.PreparedStatement;
import io.vertx.sqlclient.internal.RowDesc;
import io.vertx.sqlclient.internal.TupleInternal;
import java.util.Arrays;

class MySQLPreparedStatement
implements PreparedStatement {
    final long statementId;
    final String sql;
    final MySQLParamDesc paramDesc;
    final MySQLRowDesc rowDesc;
    final boolean closeAfterUsage;
    private boolean sendTypesToServer;
    private final DataType[] bindingTypes;
    boolean isCursorOpen;

    MySQLPreparedStatement(String sql, long statementId, MySQLParamDesc paramDesc, MySQLRowDesc rowDesc, boolean closeAfterUsage) {
        this.statementId = statementId;
        this.paramDesc = paramDesc;
        this.rowDesc = rowDesc;
        this.sql = sql;
        this.closeAfterUsage = closeAfterUsage;
        this.bindingTypes = new DataType[paramDesc.paramDefinitions().length];
        this.cleanBindings();
    }

    public ParamDesc paramDesc() {
        return this.paramDesc;
    }

    public RowDesc rowDesc() {
        return this.rowDesc;
    }

    public String sql() {
        return this.sql;
    }

    public String prepare(TupleInternal values) {
        int paramDescLength;
        int numberOfParameters = values.size();
        if (numberOfParameters != (paramDescLength = this.paramDesc.paramDefinitions().length)) {
            return ErrorMessageFactory.buildWhenArgumentsLengthNotMatched((int)paramDescLength, (int)numberOfParameters);
        }
        return null;
    }

    boolean sendTypesToServer() {
        return this.sendTypesToServer;
    }

    DataType[] bindingTypes() {
        return this.bindingTypes;
    }

    void cleanBindings() {
        this.sendTypesToServer = true;
        Arrays.fill((Object[])this.bindingTypes, (Object)DataType.UNBIND);
    }

    public String bindParameters(Tuple params) {
        int paramDescLength;
        int numberOfParameters = params.size();
        if (numberOfParameters != (paramDescLength = this.paramDesc.paramDefinitions().length)) {
            return ErrorMessageFactory.buildWhenArgumentsLengthNotMatched((int)paramDescLength, (int)numberOfParameters);
        }
        boolean reboundParameters = false;
        for (int i = 0; i < params.size(); ++i) {
            DataType paramDataType = this.bindingTypes[i];
            Object value = params.getValue(i);
            DataType dataType = DataTypeCodec.inferDataTypeByEncodingValue(value);
            if (paramDataType == dataType) continue;
            this.bindingTypes[i] = dataType;
            reboundParameters = true;
        }
        this.sendTypesToServer = reboundParameters;
        return null;
    }
}

