/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.spi;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.impl.MySQLConnectionFactory;
import io.vertx.mysqlclient.impl.MySQLConnectionImpl;
import io.vertx.mysqlclient.impl.MySQLConnectionUriParser;
import io.vertx.mysqlclient.impl.MySQLPoolOptions;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.SqlConnectionInternal;
import io.vertx.sqlclient.internal.pool.CloseablePool;
import io.vertx.sqlclient.internal.pool.PoolImpl;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;
import java.util.function.Supplier;

public class MySQLDriver
implements Driver<MySQLConnectOptions> {
    private static final String SHARED_CLIENT_KEY = "__vertx.shared.mysqlclient";
    public static final MySQLDriver INSTANCE = new MySQLDriver();

    public MySQLConnectOptions downcast(SqlConnectOptions connectOptions) {
        return connectOptions instanceof MySQLConnectOptions ? (MySQLConnectOptions)connectOptions : new MySQLConnectOptions(connectOptions);
    }

    public Pool newPool(Vertx vertx, Supplier<Future<MySQLConnectOptions>> databases, PoolOptions options, NetClientOptions transportOptions, Handler<SqlConnection> connectHandler, CloseFuture closeFuture) {
        VertxInternal vx = (VertxInternal)vertx;
        PoolImpl pool = options.isShared() ? (PoolImpl)vx.createSharedResource(SHARED_CLIENT_KEY, options.getName(), closeFuture, cf -> this.newPoolImpl(vx, connectHandler, databases, options, transportOptions, (CloseFuture)cf)) : this.newPoolImpl(vx, connectHandler, databases, options, transportOptions, closeFuture);
        return new CloseablePool(vx, closeFuture, (Pool)pool);
    }

    private PoolImpl newPoolImpl(VertxInternal vertx, Handler<SqlConnection> connectHandler, Supplier<Future<MySQLConnectOptions>> databases, PoolOptions poolOptions, NetClientOptions transportOptions, CloseFuture closeFuture) {
        boolean pipelinedPool = poolOptions instanceof MySQLPoolOptions && ((MySQLPoolOptions)poolOptions).isPipelined();
        ConnectionFactory<MySQLConnectOptions> factory = this.createConnectionFactory((Vertx)vertx, transportOptions);
        PoolImpl pool = new PoolImpl(vertx, (Driver)this, pipelinedPool, poolOptions, null, null, context -> factory.connect(context, (Future)databases.get()), connectHandler, closeFuture);
        pool.init();
        closeFuture.add(factory);
        return pool;
    }

    public MySQLConnectOptions parseConnectionUri(String uri) {
        JsonObject conf = MySQLConnectionUriParser.parse(uri, false);
        return conf == null ? null : new MySQLConnectOptions(conf);
    }

    public boolean acceptsOptions(SqlConnectOptions options) {
        return options instanceof MySQLConnectOptions || SqlConnectOptions.class.equals(options.getClass());
    }

    public ConnectionFactory<MySQLConnectOptions> createConnectionFactory(Vertx vertx, NetClientOptions transportOptions) {
        return new MySQLConnectionFactory((VertxInternal)vertx);
    }

    public SqlConnectionInternal wrapConnection(ContextInternal context, ConnectionFactory<MySQLConnectOptions> factory, Connection conn) {
        return new MySQLConnectionImpl(context, factory, conn);
    }
}

