/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.asyncsql.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.asyncsql.AsyncSQLClient;
import io.vertx.ext.asyncsql.impl.BaseSQLClient;
import io.vertx.ext.asyncsql.impl.MYSQLClientImpl;
import io.vertx.ext.asyncsql.impl.PostgreSQLClientImpl;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.SQLRowStream;
import io.vertx.ext.sql.UpdateResult;
import java.util.function.Function;

public class AsyncSQLClientImpl
implements AsyncSQLClient {
    private final BaseSQLClient baseClient;

    public AsyncSQLClientImpl(Vertx vertx, JsonObject config, boolean mysql) {
        this.baseClient = mysql ? new MYSQLClientImpl(vertx, config) : new PostgreSQLClientImpl(vertx, config);
    }

    public void close() {
        this.baseClient.close(null);
    }

    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.baseClient.close(completionHandler);
    }

    public SQLClient getConnection(Handler<AsyncResult<SQLConnection>> handler) {
        this.baseClient.getConnection(handler);
        return this;
    }

    public SQLClient query(String sql, Handler<AsyncResult<ResultSet>> handler) {
        this.executeDirect(conn -> Future.future(f -> conn.query(sql, (Handler)f)), handler);
        return this;
    }

    public SQLClient queryStream(String sql, Handler<AsyncResult<SQLRowStream>> handler) {
        this.executeDirect(conn -> Future.future(f -> conn.queryStream(sql, (Handler)f)), handler);
        return this;
    }

    public SQLClient queryStreamWithParams(String sql, JsonArray params, Handler<AsyncResult<SQLRowStream>> handler) {
        this.executeDirect(conn -> Future.future(f -> conn.queryStreamWithParams(sql, params, (Handler)f)), handler);
        return this;
    }

    public SQLClient queryWithParams(String sql, JsonArray params, Handler<AsyncResult<ResultSet>> handler) {
        this.executeDirect(conn -> Future.future(f -> conn.queryWithParams(sql, params, (Handler)f)), handler);
        return this;
    }

    public SQLClient update(String sql, Handler<AsyncResult<UpdateResult>> handler) {
        this.executeDirect(conn -> Future.future(f -> conn.update(sql, (Handler)f)), handler);
        return this;
    }

    public SQLClient updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> handler) {
        this.executeDirect(conn -> Future.future(f -> conn.updateWithParams(sql, params, (Handler)f)), handler);
        return this;
    }

    public SQLClient call(String sql, Handler<AsyncResult<ResultSet>> handler) {
        this.executeDirect(conn -> Future.future(f -> conn.call(sql, (Handler)f)), handler);
        return this;
    }

    public SQLClient callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<ResultSet>> handler) {
        this.executeDirect(conn -> Future.future(f -> conn.callWithParams(sql, params, outputs, (Handler)f)), handler);
        return this;
    }

    private <T> void executeDirect(Function<SQLConnection, Future<T>> action, Handler<AsyncResult<T>> handler) {
        this.getConnection((Handler<AsyncResult<SQLConnection>>)((Handler)getConnection -> {
            if (getConnection.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)getConnection.cause()));
            } else {
                Future future;
                SQLConnection conn = (SQLConnection)getConnection.result();
                try {
                    future = (Future)action.apply(conn);
                }
                catch (Throwable e) {
                    future = Future.failedFuture((Throwable)e);
                }
                future.setHandler(asyncResult -> conn.close(close -> {
                    if (close.failed()) {
                        handler.handle((Object)Future.failedFuture((Throwable)close.cause()));
                    } else {
                        handler.handle(asyncResult);
                    }
                }));
            }
        }));
    }
}

