/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.asyncsql.impl;

import com.github.jasync.sql.db.RowData;
import com.github.jasync.sql.db.util.ExecutorServiceUtils;
import io.netty.channel.EventLoopGroup;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.asyncsql.impl.VxContextAwareExecutor;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public final class ConversionUtils {
    private ConversionUtils() {
    }

    static <T> Future<T> completableFutureToVertx(CompletableFuture<T> future, Vertx vertx) {
        Future fut = Future.future();
        ((CompletableFuture)future.whenCompleteAsync((result, error) -> {
            if (error != null) {
                fut.fail(error);
            } else {
                fut.complete(result);
            }
        }, ConversionUtils.vertxToExecutor(vertx))).exceptionally(error -> {
            Handler exceptionHandler = vertx.getOrCreateContext().exceptionHandler();
            if (exceptionHandler != null) {
                exceptionHandler.handle(error);
            }
            return null;
        });
        return fut;
    }

    static <T> Future<Void> completableFutureToVertxVoid(CompletableFuture<T> future, Vertx vertx) {
        Future fut = Future.future();
        ((CompletableFuture)future.whenCompleteAsync((ignored, error) -> {
            if (error != null) {
                fut.fail(error);
            } else {
                fut.complete();
            }
        }, ConversionUtils.vertxToExecutor(vertx))).exceptionally(error -> {
            Handler exceptionHandler = vertx.getOrCreateContext().exceptionHandler();
            if (exceptionHandler != null) {
                exceptionHandler.handle(error);
            }
            return null;
        });
        return fut;
    }

    static <T> void connectCompletableFutureWithHandler(CompletableFuture<T> future, Vertx vertx, Handler<AsyncResult<T>> handler) {
        ((CompletableFuture)future.whenCompleteAsync((result, error) -> {
            if (error != null) {
                handler.handle((Object)Future.failedFuture((Throwable)error));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)result));
            }
        }, ConversionUtils.vertxToExecutor(vertx))).exceptionally(error -> {
            Handler exceptionHandler = vertx.getOrCreateContext().exceptionHandler();
            if (exceptionHandler != null) {
                exceptionHandler.handle(error);
            }
            return null;
        });
    }

    static <T> void connectCompletableFutureWithVoidHandler(CompletableFuture<T> future, Vertx vertx, Handler<AsyncResult<Void>> handler) {
        ((CompletableFuture)future.whenCompleteAsync((ignored, error) -> {
            if (error != null) {
                handler.handle((Object)Future.failedFuture((Throwable)error));
            } else {
                handler.handle((Object)Future.succeededFuture());
            }
        }, ConversionUtils.vertxToExecutor(vertx))).exceptionally(error -> {
            Handler exceptionHandler = vertx.getOrCreateContext().exceptionHandler();
            if (exceptionHandler != null) {
                exceptionHandler.handle(error);
            }
            return null;
        });
    }

    public static Executor vertxToExecutor(Vertx vertx) {
        EventLoopGroup eventLoopGroup = vertx.nettyEventLoopGroup();
        return eventLoopGroup == null ? ExecutorServiceUtils.INSTANCE.getCommonPool() : new VxContextAwareExecutor(vertx);
    }

    static List<Object> WrapList(JsonArray array) {
        return array.getList();
    }

    static JsonArray rowToJsonArray(RowData data) {
        JsonArray array = new JsonArray();
        data.forEach(value -> ConversionUtils.convertValue(array, value));
        return array;
    }

    private static void convertValue(JsonArray array, Object value) {
        if (value == null) {
            array.addNull();
        } else if (value instanceof BigDecimal) {
            array.add(value.toString());
        } else if (value instanceof LocalDateTime) {
            array.add(value.toString());
        } else if (value instanceof LocalDate) {
            array.add(value.toString());
        } else if (value instanceof LocalTime) {
            array.add(value.toString());
        } else if (value instanceof DateTime) {
            array.add(Instant.ofEpochMilli(((DateTime)value).getMillis()));
        } else if (value instanceof Duration) {
            Duration duration = (Duration)value;
            array.add(String.format("%02d:%02d:%02d.%03d", duration.toHours() % 24L, duration.toMinutes() % 60L, duration.getSeconds() % 60L, duration.toMillis() % 1000L));
        } else if (value instanceof UUID) {
            array.add(value.toString());
        } else if (value instanceof List) {
            JsonArray subArray = new JsonArray();
            List list = (List)value;
            for (Object item : list) {
                ConversionUtils.convertValue(subArray, item);
            }
            array.add(subArray);
        } else {
            array.add(value);
        }
    }
}

