/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.asyncsql.impl;

import com.github.jasync.sql.db.Connection;
import com.github.jasync.sql.db.ConnectionPoolConfiguration;
import com.github.jasync.sql.db.SSLConfiguration;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.asyncsql.impl.pool.AsyncConnectionPool;
import io.vertx.ext.sql.SQLConnection;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import kotlinx.coroutines.Dispatchers;

public abstract class BaseSQLClient {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Vertx vertx;
    protected final JsonObject globalConfig;
    private long testTimeout;

    public BaseSQLClient(Vertx vertx, JsonObject globalConfig) {
        this.vertx = vertx;
        this.globalConfig = globalConfig;
    }

    protected abstract AsyncConnectionPool pool();

    protected abstract SQLConnection createFromPool(Connection var1, AsyncConnectionPool var2, Vertx var3);

    public void getConnection(Handler<AsyncResult<SQLConnection>> handler) {
        this.pool().take((Handler<AsyncResult<Connection>>)((Handler)ar -> {
            if (ar.succeeded()) {
                AsyncConnectionPool pool = this.pool();
                handler.handle((Object)Future.succeededFuture((Object)this.createFromPool((Connection)ar.result(), pool, this.vertx)));
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.log.info((Object)("Stopping async SQL client " + this));
        this.pool().close((Handler<AsyncResult<Void>>)((Handler)ar -> {
            if (ar.succeeded()) {
                if (handler != null) {
                    handler.handle((Object)Future.succeededFuture());
                }
            } else if (handler != null) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }));
    }

    public void close() {
        this.close(null);
    }

    protected ConnectionPoolConfiguration getConnectionConfiguration(String defaultHost, int defaultPort, String defaultDatabase, String defaultUser, String defaultPassword, String defaultCharset, long defaultConnectTimeout, long defaultTestTimeout, JsonObject config) {
        String host = config.getString("host", defaultHost);
        int port = config.getInteger("port", Integer.valueOf(defaultPort));
        String username = config.getString("username", defaultUser);
        String password = config.getString("password", defaultPassword);
        String database = config.getString("database", defaultDatabase);
        Charset charset = Charset.forName(config.getString("charset", defaultCharset));
        long connectTimeout = config.getLong("connectTimeout", Long.valueOf(defaultConnectTimeout));
        long testTimeout = config.getLong("testTimeout", Long.valueOf(defaultTestTimeout));
        Long queryTimeout = config.getLong("queryTimeout");
        Map<String, String> sslConfig = this.buildSslConfig(config);
        String applicationName = config.getString("applicationName");
        this.log.info((Object)("Creating configuration for " + host + ":" + port));
        return new ConnectionPoolConfiguration(host, port, database, username, password, 1, 0L, 0, 0L, connectTimeout, testTimeout, queryTimeout, this.vertx.nettyEventLoopGroup(), (Executor)this.vertx.nettyEventLoopGroup(), Dispatchers.getDefault(), new SSLConfiguration(sslConfig), charset, 0x1000000, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, applicationName);
    }

    private Map<String, String> buildSslConfig(JsonObject config) {
        HashMap<String, String> sslConfig = new HashMap<String, String>();
        if (config.getString("sslMode") != null) {
            sslConfig.put("sslmode", config.getString("sslMode"));
        }
        if (config.getString("sslRootCert") != null) {
            sslConfig.put("sslrootcert", config.getString("sslRootCert"));
        }
        return sslConfig;
    }
}

