/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.asyncsql.impl;

import com.github.jasync.sql.db.Connection;
import com.github.jasync.sql.db.QueryResult;
import com.github.jasync.sql.db.ResultSet;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.asyncsql.impl.AsyncSQLRowStream;
import io.vertx.ext.asyncsql.impl.ConversionUtils;
import io.vertx.ext.asyncsql.impl.pool.AsyncConnectionPool;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.ext.sql.SQLRowStream;
import io.vertx.ext.sql.TransactionIsolation;
import io.vertx.ext.sql.UpdateResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AsyncSQLConnectionImpl
implements SQLConnection {
    private final Vertx vertx;
    private volatile boolean inTransaction = false;
    private boolean inAutoCommit = true;
    private final Connection connection;
    private final AsyncConnectionPool pool;

    public AsyncSQLConnectionImpl(Connection connection, AsyncConnectionPool pool, Vertx vertx) {
        this.connection = connection;
        this.pool = pool;
        this.vertx = vertx;
    }

    protected abstract String getStartTransactionStatement();

    public SQLConnection call(String sql, Handler<AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public SQLConnection callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public SQLConnection setOptions(SQLOptions options) {
        throw new UnsupportedOperationException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLConnection setAutoCommit(boolean autoCommit, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut;
        AsyncSQLConnectionImpl asyncSQLConnectionImpl = this;
        synchronized (asyncSQLConnectionImpl) {
            if (this.inTransaction && autoCommit) {
                this.inTransaction = false;
                fut = ConversionUtils.completableFutureToVertxVoid(this.connection.sendQuery("COMMIT"), this.vertx);
            } else {
                fut = Future.succeededFuture();
            }
            this.inAutoCommit = autoCommit;
        }
        fut.setHandler(handler);
        return this;
    }

    public SQLConnection execute(String sql, Handler<AsyncResult<Void>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> ConversionUtils.connectCompletableFutureWithVoidHandler(this.connection.sendQuery(sql), this.vertx, handler)));
        return this;
    }

    public SQLConnection query(String sql, Handler<AsyncResult<io.vertx.ext.sql.ResultSet>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> ConversionUtils.connectCompletableFutureWithHandler(this.connection.sendQuery(sql), this.vertx, this.handleAsyncQueryResultToResultSet(handler))));
        return this;
    }

    public SQLConnection queryStream(String sql, Handler<AsyncResult<SQLRowStream>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> ConversionUtils.connectCompletableFutureWithHandler(this.connection.sendQuery(sql), this.vertx, this.handleAsyncQueryResultToRowStream(handler))));
        return this;
    }

    public SQLConnection queryWithParams(String sql, JsonArray params, Handler<AsyncResult<io.vertx.ext.sql.ResultSet>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> ConversionUtils.connectCompletableFutureWithHandler(this.connection.sendPreparedStatement(sql, ConversionUtils.WrapList(params)), this.vertx, this.handleAsyncQueryResultToResultSet(handler))));
        return this;
    }

    public SQLConnection queryStreamWithParams(String sql, JsonArray params, Handler<AsyncResult<SQLRowStream>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> ConversionUtils.connectCompletableFutureWithHandler(this.connection.sendPreparedStatement(sql, ConversionUtils.WrapList(params)), this.vertx, this.handleAsyncQueryResultToRowStream(handler))));
        return this;
    }

    public SQLConnection update(String sql, Handler<AsyncResult<UpdateResult>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> ConversionUtils.connectCompletableFutureWithHandler(this.connection.sendQuery(sql), this.vertx, this.handleAsyncUpdateResultToResultSet(handler))));
        return this;
    }

    public SQLConnection updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> ConversionUtils.connectCompletableFutureWithHandler(this.connection.sendPreparedStatement(sql, ConversionUtils.WrapList(params)), this.vertx, this.handleAsyncUpdateResultToResultSet(handler))));
        return this;
    }

    public synchronized void close(Handler<AsyncResult<Void>> handler) {
        this.inAutoCommit = true;
        if (this.inTransaction) {
            this.inTransaction = false;
            Future future = ConversionUtils.completableFutureToVertx(this.connection.sendQuery("COMMIT"), this.vertx);
            future.setHandler(v -> {
                this.pool.giveBack(this.connection);
                handler.handle((Object)Future.succeededFuture());
            });
        } else {
            this.pool.giveBack(this.connection);
            handler.handle((Object)Future.succeededFuture());
        }
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public SQLConnection commit(Handler<AsyncResult<Void>> handler) {
        return this.endAndStartTransaction("COMMIT", handler);
    }

    public SQLConnection rollback(Handler<AsyncResult<Void>> handler) {
        return this.endAndStartTransaction("ROLLBACK", handler);
    }

    public SQLConnection setTransactionIsolation(TransactionIsolation transactionIsolation, Handler<AsyncResult<Void>> handler) {
        String sql;
        switch (transactionIsolation) {
            case READ_UNCOMMITTED: {
                sql = "SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED";
                break;
            }
            case REPEATABLE_READ: {
                sql = "SET TRANSACTION ISOLATION LEVEL REPEATABLE READ";
                break;
            }
            case READ_COMMITTED: {
                sql = "SET TRANSACTION ISOLATION LEVEL READ COMMITTED";
                break;
            }
            case SERIALIZABLE: {
                sql = "SET TRANSACTION ISOLATION LEVEL SERIALIZABLE";
                break;
            }
            default: {
                sql = null;
            }
        }
        if (sql == null) {
            handler.handle((Object)Future.succeededFuture());
            return this;
        }
        return this.execute(sql, handler);
    }

    public SQLConnection getTransactionIsolation(Handler<AsyncResult<TransactionIsolation>> handler) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public SQLConnection batch(List<String> sqlStatements, Handler<AsyncResult<List<Integer>>> handler) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public SQLConnection batchWithParams(String sqlStatement, List<JsonArray> args, Handler<AsyncResult<List<Integer>>> handler) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public SQLConnection batchCallableWithParams(String sqlStatement, List<JsonArray> inArgs, List<JsonArray> outArgs, Handler<AsyncResult<List<Integer>>> handler) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <C> C unwrap() {
        return (C)this.connection;
    }

    private SQLConnection endAndStartTransaction(String command, Handler<AsyncResult<Void>> handler) {
        if (this.inTransaction) {
            this.inTransaction = false;
            ConversionUtils.completableFutureToVertx(this.connection.sendQuery(command), this.vertx).setHandler(ar -> {
                if (ar.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                } else {
                    ConversionUtils.completableFutureToVertx(this.connection.sendQuery(this.getStartTransactionStatement()), this.vertx).setHandler(ar2 -> {
                        if (ar2.failed()) {
                            handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                        } else {
                            this.inTransaction = true;
                            handler.handle((Object)Future.succeededFuture());
                        }
                    });
                }
            });
        } else if (this.inAutoCommit) {
            handler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Not in transaction currently")));
        } else {
            handler.handle((Object)Future.succeededFuture());
        }
        return this;
    }

    private synchronized void beginTransactionIfNeeded(Handler<AsyncResult<Void>> action) {
        if (!this.inAutoCommit && !this.inTransaction) {
            this.inTransaction = true;
            ConversionUtils.completableFutureToVertxVoid(this.connection.sendQuery(this.getStartTransactionStatement()), this.vertx).setHandler(action);
        } else {
            action.handle((Object)Future.succeededFuture());
        }
    }

    private Handler<AsyncResult<QueryResult>> handleAsyncQueryResultToResultSet(Handler<AsyncResult<io.vertx.ext.sql.ResultSet>> handler) {
        return ar -> {
            if (ar.succeeded()) {
                io.vertx.ext.sql.ResultSet result;
                try {
                    result = this.queryResultToResultSet((QueryResult)ar.result());
                }
                catch (Throwable e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                    return;
                }
                handler.handle((Object)Future.succeededFuture((Object)result));
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        };
    }

    private Handler<AsyncResult<QueryResult>> handleAsyncQueryResultToRowStream(Handler<AsyncResult<SQLRowStream>> handler) {
        return ar -> {
            if (ar.succeeded()) {
                AsyncSQLRowStream rowStream;
                try {
                    rowStream = new AsyncSQLRowStream((QueryResult)ar.result());
                }
                catch (Throwable e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                    return;
                }
                handler.handle((Object)Future.succeededFuture((Object)rowStream));
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        };
    }

    private io.vertx.ext.sql.ResultSet queryResultToResultSet(QueryResult qr) {
        ResultSet rows = qr.getRows();
        if (rows == null) {
            return new io.vertx.ext.sql.ResultSet(Collections.emptyList(), Collections.emptyList(), null);
        }
        List names = rows.columnNames();
        List<JsonArray> arrays = this.rowDataSeqToJsonArray(rows);
        return new io.vertx.ext.sql.ResultSet(names, arrays, null);
    }

    private Handler<AsyncResult<QueryResult>> handleAsyncUpdateResultToResultSet(Handler<AsyncResult<UpdateResult>> handler) {
        return ar -> {
            if (ar.succeeded()) {
                UpdateResult result;
                try {
                    result = this.queryResultToUpdateResult((QueryResult)ar.result());
                }
                catch (Throwable e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                    return;
                }
                handler.handle((Object)Future.succeededFuture((Object)result));
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        };
    }

    protected UpdateResult queryResultToUpdateResult(QueryResult qr) {
        int affected = (int)qr.getRowsAffected();
        return new UpdateResult(affected, new JsonArray());
    }

    private List<JsonArray> rowDataSeqToJsonArray(ResultSet set) {
        ArrayList<JsonArray> list = new ArrayList<JsonArray>();
        set.forEach(row -> list.add(ConversionUtils.rowToJsonArray(row)));
        return list;
    }
}

