/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.asyncsql.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.asyncsql.AsyncSQLClient;
import io.vertx.ext.asyncsql.impl.ClientHolder;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.SQLRowStream;
import io.vertx.ext.sql.UpdateResult;

public class ClientWrapper
implements AsyncSQLClient {
    private final ClientHolder holder;
    private final AsyncSQLClient client;

    public ClientWrapper(ClientHolder holder) {
        this.holder = holder;
        this.client = holder.client();
    }

    public void close(Handler<AsyncResult<Void>> whenDone) {
        this.holder.close(whenDone);
    }

    public void close() {
        this.holder.close(null);
    }

    public SQLClient getConnection(Handler<AsyncResult<SQLConnection>> handler) {
        return this.client.getConnection(handler);
    }

    public SQLClient query(String sql, Handler<AsyncResult<ResultSet>> handler) {
        this.client.query(sql, handler);
        return this;
    }

    public SQLClient queryStream(String sql, Handler<AsyncResult<SQLRowStream>> handler) {
        this.client.queryStream(sql, handler);
        return this;
    }

    public SQLClient queryStreamWithParams(String sql, JsonArray params, Handler<AsyncResult<SQLRowStream>> handler) {
        this.client.queryStreamWithParams(sql, params, handler);
        return this;
    }

    public SQLClient queryWithParams(String sql, JsonArray params, Handler<AsyncResult<ResultSet>> handler) {
        this.client.queryWithParams(sql, params, handler);
        return this;
    }

    public SQLClient update(String sql, Handler<AsyncResult<UpdateResult>> handler) {
        this.client.update(sql, handler);
        return this;
    }

    public SQLClient updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> handler) {
        this.client.updateWithParams(sql, params, handler);
        return this;
    }

    public SQLClient call(String sql, Handler<AsyncResult<ResultSet>> handler) {
        this.client.call(sql, handler);
        return this;
    }

    public SQLClient callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<ResultSet>> handler) {
        this.client.callWithParams(sql, params, outputs, handler);
        return this;
    }
}

