/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.asyncsql.impl;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.Configuration$;
import com.github.mauricio.async.db.Connection;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.ext.asyncsql.impl.AsyncSQLConnectionImpl;
import io.vertx.ext.asyncsql.impl.BaseSQLClient;
import io.vertx.ext.asyncsql.impl.pool.AsyncConnectionPool;
import io.vertx.ext.asyncsql.impl.pool.AsyncConnectionPool$;
import io.vertx.ext.asyncsql.impl.pool.SimpleExecutionContext$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public abstract class BaseSQLClient$class {
    public static Integer maxPoolSize(BaseSQLClient $this) {
        return $this.config().getInteger("maxPoolSize", Predef$.MODULE$.int2Integer(10));
    }

    public static Integer transactionTimeout(BaseSQLClient $this) {
        return $this.config().getInteger("transactionTimeout", Predef$.MODULE$.int2Integer(500));
    }

    public static Configuration configuration(BaseSQLClient $this) {
        return BaseSQLClient$class.getConfiguration($this, $this.config());
    }

    public static AsyncConnectionPool pool(BaseSQLClient $this) {
        return AsyncConnectionPool$.MODULE$.apply($this.vertx(), Predef$.MODULE$.Integer2int($this.maxPoolSize()), $this.configuration(), $this.poolFactory());
    }

    public static String registerAddress(BaseSQLClient $this) {
        return $this.config().getString("address");
    }

    public static void getConnection(BaseSQLClient $this, Handler handler) {
        $this.pool().take().onComplete((Function1)new Serializable($this, handler){
            private final /* synthetic */ BaseSQLClient $outer;
            private final Handler handler$1;

            public final void apply(Try<Connection> x0$1) {
                Try<Connection> try_;
                block4: {
                    block3: {
                        block2: {
                            try_ = x0$1;
                            if (!(try_ instanceof Success)) break block2;
                            Success success = (Success)try_;
                            Connection conn = (Connection)success.value();
                            AsyncSQLConnectionImpl connection = new AsyncSQLConnectionImpl(conn, this.$outer.pool(), this.$outer.executionContext());
                            this.handler$1.handle((Object)Future.succeededFuture((Object)connection));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(try_ instanceof Failure)) break block4;
                        Failure failure = (Failure)try_;
                        Throwable ex = failure.exception();
                        this.handler$1.handle((Object)Future.failedFuture((Throwable)ex));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(try_);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.handler$1 = handler$1;
            }
        }, $this.executionContext());
    }

    public static void close(BaseSQLClient $this, Handler stopped) {
        $this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping AsyncSqlClient:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.getClass().getName()})));
        $this.pool().close().onComplete((Function1)new Serializable($this, stopped){
            private final Handler stopped$1;

            public final void apply(Try<AsyncConnectionPool> x0$2) {
                Try<AsyncConnectionPool> try_;
                block4: {
                    block3: {
                        block2: {
                            try_ = x0$2;
                            if (!(try_ instanceof Success)) break block2;
                            this.stopped$1.handle((Object)Future.succeededFuture());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(try_ instanceof Failure)) break block4;
                        Failure failure = (Failure)try_;
                        Throwable ex = failure.exception();
                        this.stopped$1.handle((Object)Future.failedFuture((Throwable)ex));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(try_);
            }
            {
                this.stopped$1 = stopped$1;
            }
        }, $this.executionContext());
    }

    private static Configuration getConfiguration(BaseSQLClient $this, JsonObject config) {
        String host = config.getString("host", $this.defaultHost());
        Integer port = config.getInteger("port", Predef$.MODULE$.int2Integer($this.defaultPort()));
        String username = config.getString("username", $this.defaultUser());
        Option password = Option$.MODULE$.apply((Object)config.getString("password")).orElse((Function0)new Serializable($this){
            private final /* synthetic */ BaseSQLClient $outer;

            public final Option<String> apply() {
                return this.$outer.defaultPassword();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Option database = Option$.MODULE$.apply((Object)config.getString("database")).orElse((Function0)new Serializable($this){
            private final /* synthetic */ BaseSQLClient $outer;

            public final Option<String> apply() {
                return this.$outer.defaultDatabase();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        $this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host=", ", defaultHost=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host, $this.defaultHost()})));
        return new Configuration(username, host, Predef$.MODULE$.Integer2int(port), password, database, Configuration$.MODULE$.apply$default$6(), Configuration$.MODULE$.apply$default$7(), Configuration$.MODULE$.apply$default$8(), Configuration$.MODULE$.apply$default$9(), Configuration$.MODULE$.apply$default$10());
    }

    public static void $init$(BaseSQLClient $this) {
        $this.io$vertx$ext$asyncsql$impl$BaseSQLClient$_setter_$logger_$eq(LoggerFactory.getLogger((Class)$this.io$vertx$ext$asyncsql$impl$BaseSQLClient$$super$getClass()));
        $this.io$vertx$ext$asyncsql$impl$BaseSQLClient$_setter_$executionContext_$eq(SimpleExecutionContext$.MODULE$.apply($this.logger()));
    }
}

