/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.asyncsql.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.Shareable;
import io.vertx.ext.asyncsql.AsyncSQLClient;
import io.vertx.ext.asyncsql.impl.AsyncSQLClientImpl;

class ClientHolder
implements Shareable {
    Vertx vertx;
    JsonObject config;
    boolean mySQL;
    Runnable closeRunner;
    AsyncSQLClient client;
    int refCount = 1;

    ClientHolder(Vertx vertx, JsonObject config, boolean mySQL, Runnable closeRunner) {
        this.vertx = vertx;
        this.config = config;
        this.mySQL = mySQL;
        this.closeRunner = closeRunner;
    }

    synchronized AsyncSQLClient client() {
        if (this.client == null) {
            this.client = new AsyncSQLClientImpl(this.vertx, this.config, this.mySQL);
        }
        return this.client;
    }

    synchronized void incRefCount() {
        ++this.refCount;
    }

    synchronized void close(Handler<AsyncResult<Void>> whenDone) {
        if (--this.refCount == 0) {
            if (this.client != null) {
                this.client.close(whenDone);
            }
            if (this.closeRunner != null) {
                this.closeRunner.run();
            }
        }
    }
}

