/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.asyncsql.impl;

import com.github.mauricio.async.db.Connection;
import com.github.mauricio.async.db.QueryResult;
import com.github.mauricio.async.db.RowData;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.asyncsql.impl.ScalaUtils;
import io.vertx.ext.asyncsql.impl.pool.AsyncConnectionPool;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.UpdateResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import scala.Function1;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.AbstractFunction1;

public class AsyncSQLConnectionImpl
implements SQLConnection {
    private final ExecutionContext executionContext;
    private volatile boolean inTransaction = false;
    private boolean inAutoCommit = true;
    private final Connection connection;
    private final AsyncConnectionPool pool;

    public AsyncSQLConnectionImpl(Connection connection, AsyncConnectionPool pool, ExecutionContext executionContext) {
        this.connection = connection;
        this.pool = pool;
        this.executionContext = executionContext;
    }

    public SQLConnection call(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public SQLConnection callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<ResultSet>> resultHandler) {
        throw new UnsupportedOperationException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLConnection setAutoCommit(boolean autoCommit, Handler<AsyncResult<Void>> handler) {
        io.vertx.core.Future<Void> fut;
        AsyncSQLConnectionImpl asyncSQLConnectionImpl = this;
        synchronized (asyncSQLConnectionImpl) {
            if (this.inTransaction && autoCommit) {
                this.inTransaction = false;
                fut = ScalaUtils.scalaToVertxVoid(this.connection.sendQuery("COMMIT"), this.executionContext);
            } else {
                fut = io.vertx.core.Future.succeededFuture();
            }
            this.inAutoCommit = autoCommit;
        }
        fut.setHandler(handler);
        return this;
    }

    public SQLConnection execute(String sql, Handler<AsyncResult<Void>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> {
            Future future = this.connection.sendQuery(sql);
            future.onComplete(ScalaUtils.toFunction1(ar -> {
                if (ar.failed()) {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                } else {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture());
                }
            }), this.executionContext);
        }));
        return this;
    }

    public SQLConnection query(String sql, Handler<AsyncResult<ResultSet>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> {
            io.vertx.core.Future future = ScalaUtils.scalaToVertx(this.connection.sendQuery(sql), this.executionContext);
            future.setHandler(ar -> {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)this.queryResultToResultSet((QueryResult)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            });
        }));
        return this;
    }

    public SQLConnection queryWithParams(String sql, JsonArray params, Handler<AsyncResult<ResultSet>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> {
            Future future = this.connection.sendPreparedStatement(sql, ScalaUtils.toScalaList(params.getList()));
            future.onComplete(ScalaUtils.toFunction1(ar -> {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)this.queryResultToResultSet((QueryResult)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }), this.executionContext);
        }));
        return this;
    }

    public SQLConnection update(String sql, Handler<AsyncResult<UpdateResult>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> {
            Future future = this.connection.sendQuery(sql);
            future.onComplete(ScalaUtils.toFunction1(ar -> {
                if (ar.failed()) {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                } else {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)this.queryResultToUpdateResult((QueryResult)ar.result())));
                }
            }), this.executionContext);
        }));
        return this;
    }

    public SQLConnection updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> {
            Future future = this.connection.sendPreparedStatement(sql, ScalaUtils.toScalaList(params.getList()));
            future.onComplete(ScalaUtils.toFunction1(ar -> {
                if (ar.failed()) {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                } else {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)this.queryResultToUpdateResult((QueryResult)ar.result())));
                }
            }), this.executionContext);
        }));
        return this;
    }

    public synchronized void close(Handler<AsyncResult<Void>> handler) {
        this.inAutoCommit = true;
        if (this.inTransaction) {
            this.inTransaction = false;
            io.vertx.core.Future future = ScalaUtils.scalaToVertx(this.connection.sendQuery("COMMIT"), this.executionContext);
            future.setHandler(v -> {
                this.pool.giveBack(this.connection);
                handler.handle((Object)io.vertx.core.Future.succeededFuture());
            });
        } else {
            this.pool.giveBack(this.connection);
            handler.handle((Object)io.vertx.core.Future.succeededFuture());
        }
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public SQLConnection commit(Handler<AsyncResult<Void>> handler) {
        return this.endAndStartTransaction("COMMIT", handler);
    }

    public SQLConnection rollback(Handler<AsyncResult<Void>> handler) {
        return this.endAndStartTransaction("ROLLBACK", handler);
    }

    private SQLConnection endAndStartTransaction(String command, Handler<AsyncResult<Void>> handler) {
        if (this.inTransaction) {
            this.inTransaction = false;
            ScalaUtils.scalaToVertx(this.connection.sendQuery(command), this.executionContext).setHandler(ar -> {
                if (ar.failed()) {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                } else {
                    ScalaUtils.scalaToVertx(this.connection.sendQuery("BEGIN"), this.executionContext).setHandler(ar2 -> {
                        if (ar2.failed()) {
                            handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                        } else {
                            this.inTransaction = true;
                            handler.handle((Object)io.vertx.core.Future.succeededFuture());
                        }
                    });
                }
            });
        } else {
            handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)new IllegalStateException("Not in transaction currently")));
        }
        return this;
    }

    private synchronized void beginTransactionIfNeeded(Handler<AsyncResult<Void>> action) {
        if (!this.inAutoCommit && !this.inTransaction) {
            this.inTransaction = true;
            ScalaUtils.scalaToVertxVoid(this.connection.sendQuery("BEGIN"), this.executionContext).setHandler(action);
        } else {
            action.handle((Object)io.vertx.core.Future.succeededFuture());
        }
    }

    private ResultSet queryResultToResultSet(QueryResult qr) {
        Option rows = qr.rows();
        if (!rows.isDefined()) {
            return new ResultSet(Collections.emptyList(), Collections.emptyList());
        }
        List names = ScalaUtils.toJavaList(((com.github.mauricio.async.db.ResultSet)rows.get()).columnNames().toList());
        List<JsonArray> arrays = this.rowDataSeqToJsonArray((com.github.mauricio.async.db.ResultSet)rows.get());
        return new ResultSet(names, arrays);
    }

    protected UpdateResult queryResultToUpdateResult(QueryResult qr) {
        int affected = (int)qr.rowsAffected();
        return new UpdateResult(affected, new JsonArray());
    }

    private List<JsonArray> rowDataSeqToJsonArray(com.github.mauricio.async.db.ResultSet set) {
        final ArrayList<JsonArray> list = new ArrayList<JsonArray>();
        set.foreach((Function1)new AbstractFunction1<RowData, Void>(){

            public Void apply(RowData row) {
                list.add(AsyncSQLConnectionImpl.this.rowToJsonArray(row));
                return null;
            }
        });
        return list;
    }

    private JsonArray rowToJsonArray(RowData data) {
        final JsonArray array = new JsonArray();
        data.foreach((Function1)new AbstractFunction1<Object, Void>(){

            public Void apply(Object value) {
                if (value == null) {
                    array.addNull();
                } else if (value instanceof LocalDateTime) {
                    array.add(value.toString());
                } else if (value instanceof LocalDate) {
                    array.add(value.toString());
                } else if (value instanceof UUID) {
                    array.add(value.toString());
                } else {
                    array.add(value);
                }
                return null;
            }
        });
        return array;
    }
}

