/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.asyncsql.impl;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.Connection;
import com.github.mauricio.async.db.SSLConfiguration;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.asyncsql.impl.VertxEventLoopExecutionContext;
import io.vertx.ext.asyncsql.impl.pool.AsyncConnectionPool;
import io.vertx.ext.sql.SQLConnection;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import scala.Option;
import scala.collection.Map$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;

public abstract class BaseSQLClient {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Vertx vertx;
    protected int maxPoolSize;
    protected int transactionTimeout;
    protected String registerAddress;

    public BaseSQLClient(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.maxPoolSize = config.getInteger("maxPoolSize", Integer.valueOf(10));
        this.transactionTimeout = config.getInteger("transactionTimeout", Integer.valueOf(500));
        this.registerAddress = config.getString("address");
    }

    protected abstract AsyncConnectionPool pool();

    protected abstract SQLConnection createFromPool(Connection var1, AsyncConnectionPool var2, ExecutionContext var3);

    public void getConnection(Handler<AsyncResult<SQLConnection>> handler) {
        this.pool().take((Handler<AsyncResult<Connection>>)((Handler)ar -> {
            if (ar.succeeded()) {
                AsyncConnectionPool pool = this.pool();
                ExecutionContext ec = VertxEventLoopExecutionContext.create(this.vertx);
                handler.handle((Object)Future.succeededFuture((Object)this.createFromPool((Connection)ar.result(), pool, ec)));
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.log.info((Object)("Stopping async SQL client " + this));
        this.pool().close((Handler<AsyncResult<Void>>)((Handler)ar -> {
            if (ar.succeeded()) {
                if (handler != null) {
                    handler.handle((Object)Future.succeededFuture());
                }
            } else if (handler != null) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }));
    }

    public void close() {
        this.close(null);
    }

    protected Configuration getConfiguration(String defaultHost, int defaultPort, String defaultDatabase, String defaultUser, String defaultPassword, String defaultCharset, long defaultConnectTimeout, long defaultTestTimeout, JsonObject config) {
        String host = config.getString("host", defaultHost);
        int port = config.getInteger("port", Integer.valueOf(defaultPort));
        String username = config.getString("username", defaultUser);
        String password = config.getString("password", defaultPassword);
        String database = config.getString("database", defaultDatabase);
        Charset charset = Charset.forName(config.getString("charset", defaultCharset));
        long connectTimeout = config.getLong("connectTimeout", Long.valueOf(defaultConnectTimeout));
        long testTimeout = config.getLong("testTimeout", Long.valueOf(defaultTestTimeout));
        Long queryTimeout = config.getLong("queryTimeout");
        Option queryTimeoutOption = queryTimeout == null ? Option.empty() : Option.apply((Object)Duration.apply((long)queryTimeout, (TimeUnit)TimeUnit.MILLISECONDS));
        this.log.info((Object)("Creating configuration for " + host + ":" + port));
        return new Configuration(username, host, port, Option.apply((Object)password), Option.apply((Object)database), SSLConfiguration.apply((Map)Map$.MODULE$.empty()), charset, 0x1000000, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, (Duration)Duration.apply((long)connectTimeout, (TimeUnit)TimeUnit.MILLISECONDS), (Duration)Duration.apply((long)testTimeout, (TimeUnit)TimeUnit.MILLISECONDS), queryTimeoutOption);
    }
}

