/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.asyncsql;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.ext.sql.SQLConnection;
import io.vertx.core.AsyncResult;
import io.vertx.reactivex.ext.sql.SQLClient;
import io.vertx.core.Handler;

/**
 * Represents an asynchronous SQL client
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.asyncsql.AsyncSQLClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.asyncsql.AsyncSQLClient.class)
public class AsyncSQLClient extends SQLClient {

  public static final io.vertx.lang.reactivex.TypeArg<AsyncSQLClient> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new AsyncSQLClient((io.vertx.ext.asyncsql.AsyncSQLClient) obj),
    AsyncSQLClient::getDelegate
  );

  private final io.vertx.ext.asyncsql.AsyncSQLClient delegate;
  
  public AsyncSQLClient(io.vertx.ext.asyncsql.AsyncSQLClient delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.asyncsql.AsyncSQLClient getDelegate() {
    return delegate;
  }


  public static  AsyncSQLClient newInstance(io.vertx.ext.asyncsql.AsyncSQLClient arg) {
    return arg != null ? new AsyncSQLClient(arg) : null;
  }
}
