require 'vertx-sql/sql_connection'
require 'vertx-sql/sql_client'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.asyncsql.AsyncSQLClient
module VertxMysqlPostgresql
  #  Represents an asynchronous SQL client
  class AsyncSQLClient < ::VertxSql::SQLClient
    # @private
    # @param j_del [::VertxMysqlPostgresql::AsyncSQLClient] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxMysqlPostgresql::AsyncSQLClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AsyncSQLClient
    end
    def @@j_api_type.wrap(obj)
      AsyncSQLClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAsyncsql::AsyncSQLClient.java_class
    end
    # @yield 
    # @return [self]
    def get_connection
      if block_given?
        @j_del.java_method(:getConnection, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSql::SQLConnection) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling get_connection()"
    end
    # @yield 
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      elsif block_given?
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
