/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.asyncsql;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.ext.sql.ResultSet;
import io.vertx.reactivex.ext.sql.SQLConnection;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.reactivex.ext.sql.SQLClient;
import io.vertx.reactivex.ext.sql.SQLOperations;

/**
 * Represents an asynchronous MySQL client
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.asyncsql.MySQLClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.asyncsql.MySQLClient.class)
public class MySQLClient extends AsyncSQLClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MySQLClient that = (MySQLClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<MySQLClient> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new MySQLClient((io.vertx.ext.asyncsql.MySQLClient) obj),
    MySQLClient::getDelegate
  );

  private final io.vertx.ext.asyncsql.MySQLClient delegate;
  
  public MySQLClient(io.vertx.ext.asyncsql.MySQLClient delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.asyncsql.MySQLClient getDelegate() {
    return delegate;
  }

  public SQLOperations querySingle(String sql, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingle(sql, handler);
    return this;
  }

  public Single<JsonArray> rxQuerySingle(String sql) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonArray>(handler -> {
      querySingle(sql, handler);
    });
  }

  public SQLOperations querySingleWithParams(String sql, JsonArray arguments, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingleWithParams(sql, arguments, handler);
    return this;
  }

  public Single<JsonArray> rxQuerySingleWithParams(String sql, JsonArray arguments) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonArray>(handler -> {
      querySingleWithParams(sql, arguments, handler);
    });
  }

  /**
   * Create a MySQL client which maintains its own pool.
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static AsyncSQLClient createNonShared(Vertx vertx, JsonObject config) { 
    AsyncSQLClient ret = AsyncSQLClient.newInstance(io.vertx.ext.asyncsql.MySQLClient.createNonShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Create a MySQL client which shares its data source with any other MySQL clients created with the same
   * data source name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @param poolName the pool name
   * @return the client
   */
  public static AsyncSQLClient createShared(Vertx vertx, JsonObject config, String poolName) { 
    AsyncSQLClient ret = AsyncSQLClient.newInstance(io.vertx.ext.asyncsql.MySQLClient.createShared(vertx.getDelegate(), config, poolName));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.asyncsql.MySQLClient#createShared} but with the default pool name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static AsyncSQLClient createShared(Vertx vertx, JsonObject config) { 
    AsyncSQLClient ret = AsyncSQLClient.newInstance(io.vertx.ext.asyncsql.MySQLClient.createShared(vertx.getDelegate(), config));
    return ret;
  }


  public static  MySQLClient newInstance(io.vertx.ext.asyncsql.MySQLClient arg) {
    return arg != null ? new MySQLClient(arg) : null;
  }
}
