/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.asyncsql.impl;

import com.github.mauricio.async.db.RowData;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import java.time.Instant;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import scala.Function1;
import scala.collection.JavaConversions;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.math.BigDecimal;
import scala.runtime.AbstractFunction1;
import scala.util.Try;

public final class ScalaUtils {
    private ScalaUtils() {
    }

    public static <T> io.vertx.core.Future<T> scalaToVertx(Future<T> future, ExecutionContext ec) {
        final io.vertx.core.Future fut = io.vertx.core.Future.future();
        future.onComplete((Function1)new AbstractFunction1<Try<T>, Void>(){

            public Void apply(Try<T> v1) {
                if (v1.isSuccess()) {
                    fut.complete(v1.get());
                } else {
                    fut.fail((Throwable)v1.failed().get());
                }
                return null;
            }
        }, ec);
        return fut;
    }

    public static <T> io.vertx.core.Future<Void> scalaToVertxVoid(Future<T> future, ExecutionContext ec) {
        final io.vertx.core.Future fut = io.vertx.core.Future.future();
        future.onComplete((Function1)new AbstractFunction1<Try<T>, Void>(){

            public Void apply(Try<T> v1) {
                if (v1.isSuccess()) {
                    fut.complete();
                } else {
                    fut.fail((Throwable)v1.failed().get());
                }
                return null;
            }
        }, ec);
        return fut;
    }

    public static <T> java.util.List<T> toJavaList(List<T> list) {
        return JavaConversions.bufferAsJavaList((Buffer)list.toBuffer());
    }

    public static <T> List<T> toScalaList(java.util.List<T> list) {
        return JavaConversions.asScalaBuffer(list).toList();
    }

    public static <V> Function1<Try<V>, Void> toFunction1(final Handler<AsyncResult<V>> code) {
        return new AbstractFunction1<Try<V>, Void>(){

            public Void apply(Try<V> v1) {
                if (v1.isSuccess()) {
                    code.handle((Object)io.vertx.core.Future.succeededFuture((Object)v1.get()));
                } else {
                    code.handle((Object)io.vertx.core.Future.failedFuture((Throwable)((Throwable)v1.failed().get())));
                }
                return null;
            }
        };
    }

    public static JsonArray rowToJsonArray(RowData data) {
        final JsonArray array = new JsonArray();
        data.foreach((Function1)new AbstractFunction1<Object, Void>(){

            public Void apply(Object value) {
                ScalaUtils.convertValue(array, value);
                return null;
            }
        });
        return array;
    }

    private static void convertValue(JsonArray array, Object value) {
        if (value == null) {
            array.addNull();
        } else if (value instanceof BigDecimal) {
            array.add(value.toString());
        } else if (value instanceof LocalDateTime) {
            array.add(value.toString());
        } else if (value instanceof LocalDate) {
            array.add(value.toString());
        } else if (value instanceof DateTime) {
            array.add(Instant.ofEpochMilli(((DateTime)value).getMillis()));
        } else if (value instanceof UUID) {
            array.add(value.toString());
        } else if (value instanceof ArrayBuffer) {
            ArrayBuffer arrayBuffer = (ArrayBuffer)value;
            final JsonArray subArray = new JsonArray();
            arrayBuffer.foreach((Function1)new AbstractFunction1<Object, Void>(){

                public Void apply(Object subValue) {
                    ScalaUtils.convertValue(subArray, subValue);
                    return null;
                }
            });
            array.add(subArray);
        } else {
            array.add(value);
        }
    }
}

