/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.asyncsql;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.ext.sql.ResultSet;
import io.vertx.rxjava.ext.sql.SQLConnection;
import io.vertx.core.AsyncResult;
import io.vertx.rxjava.ext.sql.SQLClient;
import io.vertx.core.Handler;
import io.vertx.rxjava.ext.sql.SQLOperations;

/**
 * Represents an asynchronous SQL client
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.asyncsql.AsyncSQLClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.asyncsql.AsyncSQLClient.class)
public class AsyncSQLClient extends SQLClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AsyncSQLClient that = (AsyncSQLClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rxjava.TypeArg<AsyncSQLClient> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new AsyncSQLClient((io.vertx.ext.asyncsql.AsyncSQLClient) obj),
    AsyncSQLClient::getDelegate
  );

  private final io.vertx.ext.asyncsql.AsyncSQLClient delegate;
  
  public AsyncSQLClient(io.vertx.ext.asyncsql.AsyncSQLClient delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.asyncsql.AsyncSQLClient getDelegate() {
    return delegate;
  }

  public SQLOperations querySingle(String sql, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingle(sql, handler);
    return this;
  }

  @Deprecated()
  public Observable<JsonArray> querySingleObservable(String sql) { 
    io.vertx.rx.java.ObservableFuture<JsonArray> handler = io.vertx.rx.java.RxHelper.observableFuture();
    querySingle(sql, handler.toHandler());
    return handler;
  }

  public Single<JsonArray> rxQuerySingle(String sql) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      querySingle(sql, fut);
    }));
  }

  public SQLOperations querySingleWithParams(String sql, JsonArray arguments, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingleWithParams(sql, arguments, handler);
    return this;
  }

  @Deprecated()
  public Observable<JsonArray> querySingleWithParamsObservable(String sql, JsonArray arguments) { 
    io.vertx.rx.java.ObservableFuture<JsonArray> handler = io.vertx.rx.java.RxHelper.observableFuture();
    querySingleWithParams(sql, arguments, handler.toHandler());
    return handler;
  }

  public Single<JsonArray> rxQuerySingleWithParams(String sql, JsonArray arguments) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      querySingleWithParams(sql, arguments, fut);
    }));
  }


  public static  AsyncSQLClient newInstance(io.vertx.ext.asyncsql.AsyncSQLClient arg) {
    return arg != null ? new AsyncSQLClient(arg) : null;
  }
}
