/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.asyncsql.impl;

import com.github.mauricio.async.db.QueryResult;
import com.github.mauricio.async.db.ResultSet;
import com.github.mauricio.async.db.RowData;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.asyncsql.impl.ScalaUtils;
import io.vertx.ext.sql.SQLRowStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Option;
import scala.collection.Iterator;

class AsyncSQLRowStream
implements SQLRowStream {
    private final ResultSet rs;
    private final Iterator<RowData> cursor;
    private List<String> columns;
    private final AtomicBoolean paused = new AtomicBoolean(false);
    private final AtomicBoolean ended = new AtomicBoolean(false);
    private Handler<JsonArray> handler;
    private Handler<Void> endHandler;
    private Handler<Void> rsClosedHandler;

    AsyncSQLRowStream(QueryResult qr) {
        Option rows = qr.rows();
        if (rows.isDefined()) {
            this.rs = (ResultSet)rows.get();
            this.cursor = this.rs.iterator();
        } else {
            this.rs = null;
            this.cursor = null;
        }
        this.paused.set(true);
    }

    public int column(String name) {
        if (this.rs == null) {
            throw new IndexOutOfBoundsException("'" + name + "' not found");
        }
        return this.columns().indexOf(name);
    }

    public List<String> columns() {
        if (this.columns == null) {
            if (this.rs == null) {
                return Collections.emptyList();
            }
            this.columns = Collections.unmodifiableList(ScalaUtils.toJavaList(this.rs.columnNames().toList()));
        }
        return this.columns;
    }

    public SQLRowStream exceptionHandler(Handler<Throwable> handler) {
        return this;
    }

    public SQLRowStream handler(Handler<JsonArray> handler) {
        this.handler = handler;
        this.resume();
        return this;
    }

    public SQLRowStream pause() {
        this.paused.compareAndSet(false, true);
        return this;
    }

    public SQLRowStream resume() {
        if (this.paused.compareAndSet(true, false)) {
            this.nextRow();
        }
        return this;
    }

    private void nextRow() {
        while (!this.paused.get()) {
            if (this.cursor.hasNext()) {
                this.handler.handle((Object)ScalaUtils.rowToJsonArray((RowData)this.cursor.next()));
                continue;
            }
            this.ended.set(true);
            if (this.rsClosedHandler != null) {
                this.rsClosedHandler.handle(null);
                break;
            }
            this.close((Handler<AsyncResult<Void>>)((Handler)c -> {
                if (this.endHandler != null) {
                    this.endHandler.handle(null);
                }
            }));
            break;
        }
    }

    public SQLRowStream endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        if (this.ended.compareAndSet(true, false)) {
            this.endHandler.handle(null);
        }
        return this;
    }

    public SQLRowStream resultSetClosedHandler(Handler<Void> handler) {
        this.rsClosedHandler = handler;
        if (this.ended.compareAndSet(true, false)) {
            this.rsClosedHandler.handle(null);
        }
        return this;
    }

    public void moreResults() {
    }

    public void close() {
        this.close(null);
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.pause();
        if (handler != null) {
            handler.handle((Object)Future.succeededFuture());
        }
    }
}

