/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.asyncsql;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.ext.sql.ResultSet;
import io.vertx.reactivex.ext.sql.SQLConnection;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.reactivex.ext.sql.SQLClient;
import io.vertx.reactivex.ext.sql.SQLOperations;

/**
 * Represents an PostgreSQL client
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.asyncsql.PostgreSQLClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.asyncsql.PostgreSQLClient.class)
public class PostgreSQLClient extends AsyncSQLClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PostgreSQLClient that = (PostgreSQLClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<PostgreSQLClient> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new PostgreSQLClient((io.vertx.ext.asyncsql.PostgreSQLClient) obj),
    PostgreSQLClient::getDelegate
  );

  private final io.vertx.ext.asyncsql.PostgreSQLClient delegate;
  
  public PostgreSQLClient(io.vertx.ext.asyncsql.PostgreSQLClient delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.asyncsql.PostgreSQLClient getDelegate() {
    return delegate;
  }

  public SQLOperations querySingle(String sql, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingle(sql, handler);
    return this;
  }

  public Maybe<JsonArray> rxQuerySingle(String sql) { 
    return new io.vertx.reactivex.core.impl.AsyncResultMaybe<JsonArray>(handler -> {
      querySingle(sql, handler);
    });
  }

  public SQLOperations querySingleWithParams(String sql, JsonArray arguments, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingleWithParams(sql, arguments, handler);
    return this;
  }

  public Maybe<JsonArray> rxQuerySingleWithParams(String sql, JsonArray arguments) { 
    return new io.vertx.reactivex.core.impl.AsyncResultMaybe<JsonArray>(handler -> {
      querySingleWithParams(sql, arguments, handler);
    });
  }

  /**
   * Create a PostgreSQL client which maintains its own pool.
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static AsyncSQLClient createNonShared(Vertx vertx, JsonObject config) { 
    AsyncSQLClient ret = AsyncSQLClient.newInstance(io.vertx.ext.asyncsql.PostgreSQLClient.createNonShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Create a PostgreSQL client which shares its pool with any other MySQL clients created with the same pool name.
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @param poolName the pool name
   * @return the client
   */
  public static AsyncSQLClient createShared(Vertx vertx, JsonObject config, String poolName) { 
    AsyncSQLClient ret = AsyncSQLClient.newInstance(io.vertx.ext.asyncsql.PostgreSQLClient.createShared(vertx.getDelegate(), config, poolName));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.asyncsql.PostgreSQLClient#createShared} but with the default pool name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static AsyncSQLClient createShared(Vertx vertx, JsonObject config) { 
    AsyncSQLClient ret = AsyncSQLClient.newInstance(io.vertx.ext.asyncsql.PostgreSQLClient.createShared(vertx.getDelegate(), config));
    return ret;
  }


  public static  PostgreSQLClient newInstance(io.vertx.ext.asyncsql.PostgreSQLClient arg) {
    return arg != null ? new PostgreSQLClient(arg) : null;
  }
}
